/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen;

import com.pg85.otg.OTG;
import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.config.ErroredFunction;
import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo3.BO3;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.resource.ICustomObjectResource;
import com.pg85.otg.customobject.resource.ICustomStructureResource;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.customobject.util.BO3Enums;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.gen.surface.FrozenSurfaceHelper;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IChunkDecorator;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Random;

public class OTGChunkDecorator
implements IChunkDecorator {
    private final Random rand;
    private final Object lockingObject = new Object();
    private int decorating = 0;
    private boolean saving;
    private boolean saveRequired;
    private Object asynChunkDecorationLock = new Object();

    public OTGChunkDecorator() {
        this.rand = new Random();
    }

    @Override
    public boolean getIsSaveRequired() {
        return this.saveRequired;
    }

    @Override
    public boolean isDecorating() {
        return this.decorating != 0;
    }

    @Override
    public void beginSave() {
        this.saving = true;
    }

    @Override
    public void endSave() {
        this.saveRequired = false;
        this.saving = false;
    }

    @Override
    public Object getLockingObject() {
        return this.lockingObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decorate(String presetFolderName, ChunkCoordinate chunkCoord, IWorldGenRegion worldGenRegion, IBiomeConfig biomeConfig, CustomStructureCache structureCache) {
        ILogger logger = OTG.getEngine().getLogger();
        boolean firstLog = false;
        while (true) {
            Object object = this.lockingObject;
            synchronized (object) {
                if (!this.saving) {
                    ++this.decorating;
                    this.saveRequired = true;
                    break;
                }
                if (firstLog) {
                    logger.log(LogLevel.WARN, LogCategory.MAIN, "Decorate waiting on SaveToDisk. Although other mods could be causing this and there may not be any problem, this can potentially cause an endless loop!");
                    firstLog = false;
                }
            }
        }
        Path otgRootFolder = OTG.getEngine().getOTGRootFolder();
        CustomObjectManager customObjectManager = OTG.getEngine().getCustomObjectManager();
        IMaterialReader materialReader = OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName);
        CustomObjectResourcesManager customObjectResourcesManager = OTG.getEngine().getCustomObjectResourcesManager();
        IModLoadedChecker modLoadedChecker = OTG.getEngine().getModLoadedChecker();
        this.doDecorate(chunkCoord, worldGenRegion, biomeConfig, logger, materialReader, otgRootFolder, structureCache, customObjectManager, customObjectResourcesManager, modLoadedChecker);
        Object object = this.lockingObject;
        synchronized (object) {
            --this.decorating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecorate(ChunkCoordinate chunkCoord, IWorldGenRegion worldGenRegion, IBiomeConfig biomeConfig, ILogger logger, IMaterialReader materialReader, Path otgRootFolder, CustomStructureCache structureCache, CustomObjectManager customObjectManager, CustomObjectResourcesManager customObjectResourcesManager, IModLoadedChecker modLoadedChecker) {
        if (biomeConfig == null) {
            if (logger.getLogCategoryEnabled(LogCategory.DECORATION)) {
                logger.log(LogLevel.ERROR, LogCategory.DECORATION, MessageFormat.format("Unknown biome at {0},{1}  (chunk {2}). Could not decorate chunk.", chunkCoord.getChunkX(), chunkCoord.getChunkZ(), chunkCoord));
            }
            return;
        }
        long resourcesSeed = worldGenRegion.getSeed();
        this.rand.setSeed(resourcesSeed);
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
        if (worldGenRegion.getWorldConfig().getCustomStructureType() == SettingsEnums.CustomStructureType.BO4) {
            Object object = this.asynChunkDecorationLock;
            synchronized (object) {
                this.plotAndSpawnBO4s(structureCache, worldGenRegion, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ()), chunkCoord, otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
            }
        }
        if (worldGenRegion.getSpawnChunk().equals(chunkCoord) && worldGenRegion.getWorldConfig().getBO3AtSpawn() != null && worldGenRegion.getWorldConfig().getBO3AtSpawn().trim().length() > 0) {
            this.handleBO3AtSpawn(worldGenRegion, chunkCoord, worldGenRegion.getWorldConfig().getBO3AtSpawn(), worldGenRegion.getPresetFolderName(), otgRootFolder, structureCache, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        }
        long startTimeAll = System.currentTimeMillis();
        for (ConfigFunction res : ((BiomeConfig)biomeConfig).getResourceQueue()) {
            long startTime = System.currentTimeMillis();
            if (res instanceof ICustomObjectResource) {
                ((ICustomObjectResource)((Object)res)).processForChunkDecoration(structureCache, worldGenRegion, this.rand, otgRootFolder, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
                if (!logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) || System.currentTimeMillis() - startTime <= 50L) continue;
                logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Processing resource " + res.toString() + " in biome " + biomeConfig.getName() + " took " + (System.currentTimeMillis() - startTime) + " Ms.");
                continue;
            }
            if (res instanceof ICustomStructureResource) {
                ((ICustomStructureResource)((Object)res)).processForChunkDecoration(structureCache, worldGenRegion, this.rand, otgRootFolder, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
                if (!logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) || System.currentTimeMillis() - startTime <= 50L) continue;
                logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Processing resource " + res.toString() + " in biome " + biomeConfig.getName() + " took " + (System.currentTimeMillis() - startTime) + " Ms.");
                continue;
            }
            if (res instanceof IBasicResource) {
                ((IBasicResource)((Object)res)).processForChunkDecoration(worldGenRegion, this.rand, logger, materialReader);
                if (!logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) || System.currentTimeMillis() - startTime <= 50L) continue;
                logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Processing resource " + res.toString() + " in biome " + biomeConfig.getName() + " took " + (System.currentTimeMillis() - startTime) + " Ms.");
                continue;
            }
            if (!(res instanceof ErroredFunction) || !logger.getLogCategoryEnabled(LogCategory.DECORATION) || ((ErroredFunction)res).isLogged) continue;
            ((ErroredFunction)res).isLogged = true;
            if (!logger.getLogCategoryEnabled(LogCategory.DECORATION)) continue;
            logger.log(LogLevel.ERROR, LogCategory.DECORATION, "Errored setting ignored for biome " + biomeConfig.getName() + " : " + this.toString());
        }
        if (logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) && System.currentTimeMillis() - startTimeAll > 50L) {
            logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Processing resources in biome " + biomeConfig.getName() + " took " + (System.currentTimeMillis() - startTimeAll) + " Ms.");
        }
    }

    public void doSnowAndIce(IWorldGenRegion worldGenRegion, ChunkCoordinate chunkCoord) {
        FrozenSurfaceHelper.freezeChunk(worldGenRegion, chunkCoord);
    }

    private void plotAndSpawnBO4s(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, ChunkCoordinate chunkCoord, ChunkCoordinate chunkBeingDecorated, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager customObjectResourcesManager, IModLoadedChecker modLoadedChecker) {
        structureCache.plotBo4Structures(worldGenRegion, this.rand, chunkCoord, otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        structureCache.plotBo4Structures(worldGenRegion, this.rand, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ()), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        structureCache.plotBo4Structures(worldGenRegion, this.rand, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ() + 1), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        structureCache.plotBo4Structures(worldGenRegion, this.rand, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ() + 1), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        this.spawnBO4(structureCache, worldGenRegion, chunkCoord, otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        this.spawnBO4(structureCache, worldGenRegion, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ()), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        this.spawnBO4(structureCache, worldGenRegion, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ() + 1), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        this.spawnBO4(structureCache, worldGenRegion, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ() + 1), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
    }

    private void spawnBO4(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, ChunkCoordinate chunkCoord, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        structureCache.spawnBo4Chunk(worldGenRegion, chunkCoord, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
    }

    private void handleBO3AtSpawn(IWorldGenRegion worldGenRegion, ChunkCoordinate targetChunk, String bo3AtSpawn, String presetFolderName, Path otgRootFolder, CustomStructureCache structureCache, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager customObjectResourcesManager, IModLoadedChecker modLoadedChecker) {
        CustomObject customObject = customObjectManager.getGlobalObjects().getObjectByName(bo3AtSpawn, presetFolderName, otgRootFolder, worldGenRegion.getLogger(), customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker);
        if (customObject != null && customObject instanceof BO3) {
            int y = 1;
            if (((BO3)customObject).getConfig().getSpawnHeight() == BO3Enums.SpawnHeightEnum.highestBlock) {
                y = worldGenRegion.getHighestBlockAboveYAt(targetChunk.getBlockX() + 15, targetChunk.getBlockZ() + 15) - 1;
            } else if (((BO3)customObject).getConfig().getSpawnHeight() == BO3Enums.SpawnHeightEnum.highestSolidBlock) {
                y = worldGenRegion.getBlockAboveSolidHeight(targetChunk.getBlockX() + 15, targetChunk.getBlockZ() + 15) - 1;
            } else if (((BO3)customObject).getConfig().getSpawnHeight() == BO3Enums.SpawnHeightEnum.randomY) {
                y = (int)((double)((BO3)customObject).getConfig().minHeight + Math.random() * (double)(((BO3)customObject).getConfig().maxHeight - ((BO3)customObject).getConfig().minHeight));
            }
            ((BO3)customObject).spawnForced(structureCache, worldGenRegion, this.rand, Rotation.NORTH, targetChunk.getBlockX() + 16 + ((BO3)customObject).getXOffset(Rotation.NORTH), y += ((BO3)customObject).getConfig().getSpawnHeightOffset(), targetChunk.getBlockZ() + 16 + ((BO3)customObject).getZOffset(Rotation.NORTH), true);
        }
    }
}

