/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen;

import com.pg85.otg.OTG;
import com.pg85.otg.gen.biome.CachedBiomeProvider;
import com.pg85.otg.gen.carver.Carver;
import com.pg85.otg.gen.carver.CaveCarver;
import com.pg85.otg.gen.carver.RavineCarver;
import com.pg85.otg.gen.noise.OctavePerlinNoiseSampler;
import com.pg85.otg.gen.noise.PerlinNoiseSampler;
import com.pg85.otg.gen.noise.legacy.NoiseGeneratorPerlinMesaBlocks;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ILayerSource;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.ISurfaceGeneratorNoiseProvider;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.gen.GeneratingChunk;
import com.pg85.otg.util.gen.JigsawStructureData;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public class OTGChunkGenerator
implements ISurfaceGeneratorNoiseProvider {
    private static final double WORLD_GEN_CONSTANT = 684.412;
    private static final float[] BIOME_WEIGHT_TABLE = OTGChunkGenerator.make(new float[4225], array -> {
        for (int x = -32; x <= 32; ++x) {
            for (int z = -32; z <= 32; ++z) {
                float f;
                array[x + 32 + (z + 32) * 65] = f = 10.0f / MathHelper.sqrt((float)(x * x + z * z) + 0.2f);
            }
        }
    });
    private static final float[] NOISE_WEIGHT_TABLE = OTGChunkGenerator.make(new float[13824], array -> {
        for (int z = 0; z < 24; ++z) {
            for (int x = 0; x < 24; ++x) {
                for (int y = 0; y < 24; ++y) {
                    array[z * 24 * 24 + x * 24 + y] = (float)OTGChunkGenerator.calculateNoiseWeight(x - 12, y - 12, z - 12);
                }
            }
        }
    });
    private final OctavePerlinNoiseSampler interpolationNoise;
    private final OctavePerlinNoiseSampler lowerInterpolatedNoise;
    private final OctavePerlinNoiseSampler upperInterpolatedNoise;
    private final OctavePerlinNoiseSampler depthNoise;
    private final Preset preset;
    private final long seed;
    private final CachedBiomeProvider cachedBiomeProvider;
    private final int noiseSizeX = 4;
    private final int noiseSizeY;
    private final int noiseSizeZ = 4;
    private final ThreadLocal<NoiseCache> noiseCache;
    private final NoiseGeneratorPerlinMesaBlocks biomeBlocksNoiseGen;
    private final Carver caves;
    private final Carver ravines;
    private ThreadLocal<double[]> biomeBlocksNoise = ThreadLocal.withInitial(() -> new double[256]);
    private ThreadLocal<Integer> lastX = ThreadLocal.withInitial(() -> Integer.MAX_VALUE);
    private ThreadLocal<Integer> lastZ = ThreadLocal.withInitial(() -> Integer.MAX_VALUE);
    private ThreadLocal<Double> lastNoise = ThreadLocal.withInitial(() -> 0.0);

    public OTGChunkGenerator(Preset preset, long seed, ILayerSource biomeProvider, IBiome[] biomesById, ILogger logger) {
        this.preset = preset;
        this.seed = seed;
        this.cachedBiomeProvider = new CachedBiomeProvider(this.seed, biomeProvider, biomesById, logger);
        Random random = new Random(seed);
        this.noiseSizeY = preset.getWorldConfig().getWorldHeightCap() / 8;
        this.interpolationNoise = new OctavePerlinNoiseSampler(random, IntStream.rangeClosed(-7, 0));
        this.lowerInterpolatedNoise = new OctavePerlinNoiseSampler(random, IntStream.rangeClosed(-15, 0));
        this.upperInterpolatedNoise = new OctavePerlinNoiseSampler(random, IntStream.rangeClosed(-15, 0));
        this.depthNoise = new OctavePerlinNoiseSampler(random, IntStream.rangeClosed(-15, 0));
        this.noiseCache = ThreadLocal.withInitial(() -> new NoiseCache(128, this.noiseSizeY + 1));
        this.biomeBlocksNoiseGen = new NoiseGeneratorPerlinMesaBlocks(random, 4);
        this.caves = new CaveCarver(256, preset.getWorldConfig());
        this.ravines = new RavineCarver(256, preset.getWorldConfig());
    }

    public ICachedBiomeProvider getCachedBiomeProvider() {
        return this.cachedBiomeProvider;
    }

    private static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    private static double getNoiseWeight(int x, int y, int z) {
        int arrayX = x + 12;
        int arrayZ = y + 12;
        int arrayY = z + 12;
        if (arrayX >= 0 && arrayX < 24) {
            if (arrayZ >= 0 && arrayZ < 24) {
                return arrayY >= 0 && arrayY < 24 ? (double)NOISE_WEIGHT_TABLE[arrayY * 24 * 24 + arrayX * 24 + arrayZ] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double calculateNoiseWeight(int x, int y, int z) {
        double sqrXZ = x * x + z * z;
        double offsetY = (double)y + 0.5;
        double sqrY = offsetY * offsetY;
        double density = Math.pow(Math.E, -(sqrY / 16.0 + sqrXZ / 16.0));
        double yOffset = -offsetY * MathHelper.fastInverseSqrt(sqrY / 2.0 + sqrXZ / 2.0) / 2.0;
        return yOffset * density;
    }

    private double sampleNoise(int x, int y, int z, double horizontalScale, double verticalScale, double horizontalStretch, double verticalStretch, double volatility1, double volatility2, double volatilityWeight1, double volatilityWeight2) {
        double delta = this.getInterpolationNoise(x, y, z, horizontalStretch, verticalStretch);
        if (delta < volatilityWeight1) {
            return this.getInterpolatedNoise(this.lowerInterpolatedNoise, x, y, z, horizontalScale, verticalScale) / 512.0 * volatility1;
        }
        if (delta > volatilityWeight2) {
            return this.getInterpolatedNoise(this.upperInterpolatedNoise, x, y, z, horizontalScale, verticalScale) / 512.0 * volatility2;
        }
        return MathHelper.lerp(delta, this.getInterpolatedNoise(this.lowerInterpolatedNoise, x, y, z, horizontalScale, verticalScale) / 512.0 * volatility1, this.getInterpolatedNoise(this.upperInterpolatedNoise, x, y, z, horizontalScale, verticalScale) / 512.0 * volatility2);
    }

    private double getInterpolationNoise(int x, int y, int z, double horizontalStretch, double verticalStretch) {
        double interpolation = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < 8; ++i) {
            PerlinNoiseSampler interpolationSampler = this.interpolationNoise.getOctave(i);
            if (interpolationSampler != null) {
                interpolation += interpolationSampler.sample(OctavePerlinNoiseSampler.maintainPrecision((double)x * horizontalStretch * amplitude), OctavePerlinNoiseSampler.maintainPrecision((double)y * verticalStretch * amplitude), OctavePerlinNoiseSampler.maintainPrecision((double)z * horizontalStretch * amplitude), verticalStretch * amplitude, (double)y * verticalStretch * amplitude) / amplitude;
            }
            amplitude /= 2.0;
        }
        return (interpolation / 10.0 + 1.0) / 2.0;
    }

    private double getInterpolatedNoise(OctavePerlinNoiseSampler sampler, int x, int y, int z, double horizontalScale, double verticalScale) {
        double noise = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < 16; ++i) {
            double scaledX = OctavePerlinNoiseSampler.maintainPrecision((double)x * horizontalScale * amplitude);
            double scaledY = OctavePerlinNoiseSampler.maintainPrecision((double)y * verticalScale * amplitude);
            double scaledZ = OctavePerlinNoiseSampler.maintainPrecision((double)z * horizontalScale * amplitude);
            double scaledVerticalScale = verticalScale * amplitude;
            PerlinNoiseSampler perlinNoiseSampler = sampler.getOctave(i);
            if (perlinNoiseSampler != null) {
                noise += perlinNoiseSampler.sample(scaledX, scaledY, scaledZ, scaledVerticalScale, (double)y * scaledVerticalScale) / amplitude;
            }
            amplitude /= 2.0;
        }
        return noise;
    }

    private double getExtraHeightAt(int x, int z, double maxAverageDepth, double maxAverageHeight) {
        double noiseHeight = this.depthNoise.sample(x * 200, 10.0, z * 200, 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (noiseHeight < 0.0) {
            noiseHeight = -noiseHeight * 0.3;
        }
        if ((noiseHeight = noiseHeight * 3.0 - 2.0) < 0.0) {
            if ((noiseHeight /= 2.0) < -1.0) {
                noiseHeight = -1.0;
            }
            noiseHeight -= maxAverageDepth;
            noiseHeight /= 1.4;
            noiseHeight /= 2.0;
        } else {
            if (noiseHeight > 1.0) {
                noiseHeight = 1.0;
            }
            noiseHeight += maxAverageHeight;
            noiseHeight /= 8.0;
        }
        return noiseHeight;
    }

    public void getNoiseColumn(double[] buffer, int x, int z) {
        this.noiseCache.get().get(buffer, x, z);
    }

    private void generateNoiseColumn(double[] noiseColumn, int noiseX, int noiseZ) {
        float weightAt;
        float heightAt;
        IBiomeConfig biome;
        int cacheZ;
        int cacheX;
        IBiomeConfig center = this.cachedBiomeProvider.getNoiseBiomeConfig(noiseX, noiseZ, true);
        int usedYSections = this.preset.getWorldConfig().getWorldHeightScale() / 8 + 1;
        float height = 0.0f;
        float volatility = 0.0f;
        double volatility1 = 0.0;
        double volatility2 = 0.0;
        double horizontalFracture = 0.0;
        double verticalFracture = 0.0;
        double volatilityWeight1 = 0.0;
        double volatilityWeight2 = 0.0;
        double maxAverageDepth = 0.0;
        double maxAverageHeight = 0.0;
        double[] chc = new double[this.noiseSizeY + 1];
        float weight = 0.0f;
        int radius = Math.max(center.getSmoothRadius(), center.getCHCSmoothRadius());
        int areaSize = radius * 2 + 1;
        IBiomeConfig[] biomes = this.cachedBiomeProvider.getNoiseBiomeConfigsForRegion(noiseX - radius, noiseZ - radius, areaSize);
        for (int x1 = -center.getSmoothRadius(); x1 <= center.getSmoothRadius(); ++x1) {
            cacheX = x1 + radius;
            for (int z1 = -center.getSmoothRadius(); z1 <= center.getSmoothRadius(); ++z1) {
                cacheZ = z1 + radius;
                biome = biomes[cacheX * areaSize + cacheZ];
                heightAt = biome.getBiomeHeight();
                weightAt = BIOME_WEIGHT_TABLE[x1 + 32 + (z1 + 32) * 65] / (heightAt + 2.0f);
                weightAt = Math.abs(weightAt);
                weight += weightAt;
                height += heightAt * weightAt;
                volatility += biome.getBiomeVolatility() * weightAt;
                volatility1 += biome.getVolatility1() * (double)weightAt;
                volatility2 += biome.getVolatility2() * (double)weightAt;
                horizontalFracture += biome.getFractureHorizontal() * (double)weightAt;
                verticalFracture += biome.getFractureVertical() * (double)weightAt;
                volatilityWeight1 += biome.getVolatilityWeight1() * (double)weightAt;
                volatilityWeight2 += biome.getVolatilityWeight2() * (double)weightAt;
                maxAverageDepth += biome.getMaxAverageDepth() * (double)weightAt;
                maxAverageHeight += biome.getMaxAverageHeight() * (double)weightAt;
            }
        }
        double chcWeight = 0.0;
        for (int x1 = -center.getCHCSmoothRadius(); x1 <= center.getCHCSmoothRadius(); ++x1) {
            cacheX = x1 + radius;
            for (int z1 = -center.getCHCSmoothRadius(); z1 <= center.getCHCSmoothRadius(); ++z1) {
                cacheZ = z1 + radius;
                biome = biomes[cacheX * areaSize + cacheZ];
                heightAt = biome.getBiomeHeight();
                weightAt = BIOME_WEIGHT_TABLE[x1 + 32 + (z1 + 32) * 65] / (heightAt + 2.0f);
                weightAt = Math.abs(weightAt);
                chcWeight += (double)weightAt;
                for (int y = 0; y < this.noiseSizeY + 1; ++y) {
                    int n = y;
                    chc[n] = chc[n] + biome.getCHCData(y) * (double)weightAt;
                }
            }
        }
        height /= weight;
        volatility /= weight;
        volatility1 /= (double)weight;
        volatility2 /= (double)weight;
        horizontalFracture /= (double)weight;
        verticalFracture /= (double)weight;
        volatilityWeight1 /= (double)weight;
        volatilityWeight2 /= (double)weight;
        maxAverageDepth /= (double)weight;
        maxAverageHeight /= (double)weight;
        int y = 0;
        while (y < this.noiseSizeY + 1) {
            int n = y++;
            chc[n] = chc[n] / chcWeight;
        }
        float extraHeight = (float)(this.getExtraHeightAt(noiseX, noiseZ, maxAverageDepth, maxAverageHeight) * 0.2);
        volatility = volatility * 0.9f + 0.1f;
        height = (height * 4.0f - 1.0f) / 8.0f;
        height = (float)usedYSections * (2.0f + height + extraHeight) / 4.0f;
        for (int y2 = 0; y2 <= this.noiseSizeY; ++y2) {
            double falloff = (double)(height - (float)y2) * 12.0 * 128.0 / (double)this.preset.getWorldConfig().getWorldHeightCap() / (double)volatility;
            if (falloff > 0.0) {
                falloff *= 4.0;
            }
            double horizontalScale = 684.412 * horizontalFracture;
            double verticalScale = 684.412 * verticalFracture;
            double noise = this.sampleNoise(noiseX, y2, noiseZ, horizontalScale, verticalScale, horizontalScale / 80.0, verticalScale / 160.0, volatility1, volatility2, volatilityWeight1, volatilityWeight2);
            if (!center.disableBiomeHeight()) {
                noise += falloff;
                if (y2 > 28) {
                    noise = MathHelper.clampedLerp(noise, -10.0, ((double)y2 - 28.0) / 4.0);
                }
            }
            noiseColumn[y2] = noise += chc[y2];
        }
    }

    public void populateNoise(int worldHeightCap, Random random, ChunkBuffer buffer, ChunkCoordinate chunkCoord, ObjectList<JigsawStructureData> structures, ObjectList<JigsawStructureData> junctions) {
        ILogger logger = OTG.getEngine().getLogger();
        ObjectListIterator structureIterator = structures.iterator();
        ObjectListIterator junctionsIterator = junctions.iterator();
        long startTime = System.currentTimeMillis();
        int[] waterLevel = new int[256];
        int blockX = chunkCoord.getBlockX();
        int blockZ = chunkCoord.getBlockZ();
        IBiome[] biomes = this.cachedBiomeProvider.getBiomesForChunk(chunkCoord);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                waterLevel[x * 16 + z] = biomes[x * 16 + z].getBiomeConfig().getWaterLevelMax();
            }
        }
        this.getClass();
        double[][][] noiseData = new double[2][4 + 1][this.noiseSizeY + 1];
        int noiseZ = 0;
        while (true) {
            this.getClass();
            if (noiseZ >= 4 + 1) break;
            noiseData[0][noiseZ] = new double[this.noiseSizeY + 1];
            double[] dArray = noiseData[0][noiseZ];
            int n = chunkCoord.getChunkX();
            this.getClass();
            int n2 = n * 4;
            int n3 = chunkCoord.getChunkZ();
            this.getClass();
            this.getNoiseColumn(dArray, n2, n3 * 4 + noiseZ);
            noiseData[1][noiseZ] = new double[this.noiseSizeY + 1];
            ++noiseZ;
        }
        int noiseX = 0;
        while (true) {
            this.getClass();
            if (noiseX >= 4) break;
            int noiseZ2 = 0;
            while (true) {
                this.getClass();
                if (noiseZ2 >= 4 + 1) break;
                double[] dArray = noiseData[1][noiseZ2];
                int n = chunkCoord.getChunkX();
                this.getClass();
                int n4 = n * 4 + noiseX + 1;
                int n5 = chunkCoord.getChunkZ();
                this.getClass();
                this.getNoiseColumn(dArray, n4, n5 * 4 + noiseZ2);
                ++noiseZ2;
            }
            noiseZ2 = 0;
            while (true) {
                this.getClass();
                if (noiseZ2 >= 4) break;
                for (int noiseY = this.noiseSizeY - 1; noiseY >= 0; --noiseY) {
                    double x0z0y0 = noiseData[0][noiseZ2][noiseY];
                    double x0z1y0 = noiseData[0][noiseZ2 + 1][noiseY];
                    double x1z0y0 = noiseData[1][noiseZ2][noiseY];
                    double x1z1y0 = noiseData[1][noiseZ2 + 1][noiseY];
                    double x0z0y1 = noiseData[0][noiseZ2][noiseY + 1];
                    double x0z1y1 = noiseData[0][noiseZ2 + 1][noiseY + 1];
                    double x1z0y1 = noiseData[1][noiseZ2][noiseY + 1];
                    double x1z1y1 = noiseData[1][noiseZ2 + 1][noiseY + 1];
                    for (int pieceY = 7; pieceY >= 0; --pieceY) {
                        int realY = noiseY * 8 + pieceY;
                        double yLerp = (double)pieceY / 8.0;
                        double x0z0 = MathHelper.lerp(yLerp, x0z0y0, x0z0y1);
                        double x1z0 = MathHelper.lerp(yLerp, x1z0y0, x1z0y1);
                        double x0z1 = MathHelper.lerp(yLerp, x0z1y0, x0z1y1);
                        double x1z1 = MathHelper.lerp(yLerp, x1z1y0, x1z1y1);
                        for (int pieceX = 0; pieceX < 4; ++pieceX) {
                            int realX = blockX + noiseX * 4 + pieceX;
                            int localX = realX & 0xF;
                            double xLerp = (double)pieceX / 4.0;
                            double z0 = MathHelper.lerp(xLerp, x0z0, x1z0);
                            double z1 = MathHelper.lerp(xLerp, x0z1, x1z1);
                            for (int pieceZ = 0; pieceZ < 4; ++pieceZ) {
                                int realZ = blockZ + noiseZ2 * 4 + pieceZ;
                                int localZ = realZ & 0xF;
                                double zLerp = (double)pieceZ / 4.0;
                                double rawNoise = MathHelper.lerp(zLerp, z0, z1);
                                double density = MathHelper.clamp(rawNoise / 200.0, -1.0, 1.0);
                                IBiomeConfig biomeConfig = biomes[localX * 16 + localZ].getBiomeConfig();
                                int structureX = 0;
                                int structureY = 0;
                                int structureZ = 0;
                                density = density / 2.0 - density * density * density / 24.0;
                                while (structureIterator.hasNext()) {
                                    JigsawStructureData structure = (JigsawStructureData)structureIterator.next();
                                    structureX = Math.max(0, Math.max(structure.minX - realX, realX - structure.maxX));
                                    structureY = realY - (structure.minY + (structure.useDelta ? structure.delta : 0));
                                    structureZ = Math.max(0, Math.max(structure.minZ - realZ, realZ - structure.maxZ));
                                    density += OTGChunkGenerator.getNoiseWeight(structureX, structureY, structureZ) * 0.8;
                                }
                                structureIterator.back(structures.size());
                                while (junctionsIterator.hasNext()) {
                                    JigsawStructureData junction = (JigsawStructureData)junctionsIterator.next();
                                    int sourceX = realX - junction.sourceX;
                                    int sourceY = realY - junction.groundY;
                                    int sourceZ = realZ - junction.sourceZ;
                                    density += OTGChunkGenerator.getNoiseWeight(sourceX, sourceY, sourceZ) * 0.4;
                                }
                                junctionsIterator.back(junctions.size());
                                if (density > 0.0) {
                                    buffer.setBlock(localX, realY, localZ, biomeConfig.getStoneBlockReplaced(realY));
                                    buffer.setHighestBlockForColumn(pieceX + noiseX * 4, noiseZ2 * 4 + pieceZ, realY);
                                    continue;
                                }
                                if (realY >= waterLevel[localX * 16 + localZ] || realY <= biomeConfig.getWaterLevelMin()) continue;
                                buffer.setBlock(localX, realY, localZ, biomeConfig.getWaterBlockReplaced(realY));
                                buffer.setHighestBlockForColumn(pieceX + noiseX * 4, noiseZ2 * 4 + pieceZ, realY);
                            }
                        }
                    }
                }
                ++noiseZ2;
            }
            double[][] xColumn = noiseData[0];
            noiseData[0] = noiseData[1];
            noiseData[1] = xColumn;
            ++noiseX;
        }
        this.doSurfaceAndGroundControl(biomes, random, worldHeightCap, this.seed, buffer, waterLevel);
        if (logger.getLogCategoryEnabled(LogCategory.PERFORMANCE) && System.currentTimeMillis() - startTime > 50L) {
            logger.log(LogLevel.WARN, LogCategory.PERFORMANCE, "Warning: Terrain generation for chunk at " + (chunkCoord.getBlockX() + 8) + " ~ " + (chunkCoord.getBlockZ() + 8) + " took " + (System.currentTimeMillis() - startTime) + " Ms.");
        }
    }

    public void carve(ChunkBuffer chunk, long seed, int chunkX, int chunkZ, BitSet carvingMask, boolean cavesEnabled, boolean ravinesEnabled) {
        if (cavesEnabled || ravinesEnabled) {
            Random random = new Random();
            for (int localChunkX = chunkX - 8; localChunkX <= chunkX + 8; ++localChunkX) {
                for (int localChunkZ = chunkZ - 8; localChunkZ <= chunkZ + 8; ++localChunkZ) {
                    this.setCarverSeed(random, seed, localChunkX, localChunkZ);
                    if (cavesEnabled && this.caves.isStartChunk(random, localChunkX, localChunkZ)) {
                        this.caves.carve(this, chunk, random, localChunkX, localChunkZ, chunkX, chunkZ, carvingMask, this.cachedBiomeProvider);
                    }
                    this.setCarverSeed(random, seed, localChunkX, localChunkZ);
                    if (!ravinesEnabled || !this.ravines.isStartChunk(random, localChunkX, localChunkZ)) continue;
                    this.ravines.carve(this, chunk, random, localChunkX, localChunkZ, chunkX, chunkZ, carvingMask, this.cachedBiomeProvider);
                }
            }
        }
    }

    private long setCarverSeed(Random random, long seed, int x, int z) {
        random.setSeed(seed);
        long i = random.nextLong();
        long j = random.nextLong();
        long k = (long)x * i ^ (long)z * j ^ seed;
        random.setSeed(k);
        return k;
    }

    public int getNoiseSizeY() {
        return this.noiseSizeY;
    }

    private void doSurfaceAndGroundControl(IBiome[] biomes, Random random, int heightCap, long worldSeed, ChunkBuffer chunkBuffer, int[] waterLevel) {
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        double d1 = 0.03125;
        this.biomeBlocksNoise.set(this.biomeBlocksNoiseGen.getRegion(this.biomeBlocksNoise.get(), chunkCoord.getBlockX(), chunkCoord.getBlockZ(), 16, 16, d1 * 2.0, d1 * 2.0, 1.0));
        GeneratingChunk generatingChunk = new GeneratingChunk(random, waterLevel, this.biomeBlocksNoise.get(), heightCap);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                IBiome biome = biomes[x * 16 + z];
                biome.getBiomeConfig().doSurfaceAndGroundControl(worldSeed, generatingChunk, chunkBuffer, chunkCoord.getBlockX() + x, chunkCoord.getBlockZ() + z, biome);
            }
        }
    }

    @Override
    public double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        double noise = this.lastNoise.get();
        if (this.lastX.get() != blockX || this.lastZ.get() != blockZ) {
            double d1 = 0.03125;
            noise = this.biomeBlocksNoiseGen.getRegion(new double[1], blockX, blockZ, 1, 1, d1 * 2.0, d1 * 2.0, 1.0)[0];
            this.lastX.set(blockX);
            this.lastZ.set(blockZ);
            this.lastNoise.set(noise);
        }
        return noise;
    }

    private class NoiseCache {
        private final long[] keys;
        private final double[] values;
        private final int mask;

        private NoiseCache(int size, int noiseSize) {
            size = MathHelper.smallestEncompassingPowerOfTwo(size);
            this.mask = size - 1;
            this.keys = new long[size];
            Arrays.fill(this.keys, Long.MIN_VALUE);
            this.values = new double[size * noiseSize];
        }

        public double[] get(double[] buffer, int noiseX, int noiseZ) {
            long key = this.key(noiseX, noiseZ);
            int idx = this.hash(key) & this.mask;
            if (this.keys[idx] == key) {
                System.arraycopy(this.values, idx * buffer.length, buffer, 0, buffer.length);
            } else {
                OTGChunkGenerator.this.generateNoiseColumn(buffer, noiseX, noiseZ);
                System.arraycopy(buffer, 0, this.values, idx * buffer.length, buffer.length);
                this.keys[idx] = key;
            }
            return buffer;
        }

        private int hash(long key) {
            return (int)HashCommon.mix((long)key);
        }

        private long key(int x, int z) {
            return MathHelper.toLong(x, z);
        }
    }
}

