/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BiomeData {
    public final int id;
    public final int rarity;
    public final int biomeSize;
    public float biomeTemperature;
    private final List<String> configIsleInBiomes;
    private final List<String> configBorderInBiomes;
    private final List<String> configOnlyBorderNearBiomes;
    private final List<String> configNotBorderNearBiomes;
    public final List<Integer> isleInBiomes = new ArrayList<Integer>();
    public final List<Integer> borderInBiomes = new ArrayList<Integer>();
    public final List<Integer> onlyBorderNearBiomes = new ArrayList<Integer>();
    public final List<Integer> notBorderNearBiomes = new ArrayList<Integer>();

    public BiomeData(int id, int rarity, int biomeSize, float biomeTemperature, List<String> configIsleInBiomes, List<String> configBorderInBiomes, List<String> configOnlyBorderNearBiomes, List<String> configNotBorderNearBiomes) {
        this.id = id;
        this.rarity = rarity;
        this.biomeSize = biomeSize;
        this.biomeTemperature = biomeTemperature;
        this.configIsleInBiomes = configIsleInBiomes;
        this.configBorderInBiomes = configBorderInBiomes;
        this.configOnlyBorderNearBiomes = configOnlyBorderNearBiomes;
        this.configNotBorderNearBiomes = configNotBorderNearBiomes;
    }

    public void init(Map<String, List<Integer>> worldBiomes) {
        for (String isleInBiomeName : this.configIsleInBiomes) {
            List<Integer> isleBiomes = worldBiomes.get(isleInBiomeName);
            if (isleBiomes == null) continue;
            for (Integer isleBiome : isleBiomes) {
                if (isleBiome == null || this.isleInBiomes.contains((int)isleBiome)) continue;
                this.isleInBiomes.add((int)isleBiome);
            }
        }
        for (String borderInBiomeName : this.configBorderInBiomes) {
            List<Integer> borderBiomes = worldBiomes.get(borderInBiomeName);
            if (borderBiomes == null) continue;
            for (Integer borderBiome : borderBiomes) {
                if (borderBiome == null || this.borderInBiomes.contains((int)borderBiome)) continue;
                this.borderInBiomes.add((int)borderBiome);
            }
        }
        for (String onlyBorderNearBiomeName : this.configOnlyBorderNearBiomes) {
            List<Integer> onlyBorderNearBiomes = worldBiomes.get(onlyBorderNearBiomeName);
            if (onlyBorderNearBiomes == null) continue;
            for (Integer onlyBorderNearBiome : onlyBorderNearBiomes) {
                if (onlyBorderNearBiome == null || this.onlyBorderNearBiomes.contains((int)onlyBorderNearBiome)) continue;
                this.onlyBorderNearBiomes.add((int)onlyBorderNearBiome);
            }
        }
        for (String notBorderNearBiomeName : this.configNotBorderNearBiomes) {
            List<Integer> notBorderNearBiomes = worldBiomes.get(notBorderNearBiomeName);
            if (notBorderNearBiomes == null) continue;
            for (Integer notBorderNearBiome : notBorderNearBiomes) {
                if (notBorderNearBiome == null || this.notBorderNearBiomes.contains((int)notBorderNearBiome)) continue;
                this.notBorderNearBiomes.add((int)notBorderNearBiome);
            }
        }
    }

    public BiomeData clone() {
        BiomeData clone = new BiomeData(this.id, this.rarity, this.biomeSize, this.biomeTemperature, new ArrayList<String>(this.configIsleInBiomes), new ArrayList<String>(this.configBorderInBiomes), new ArrayList<String>(this.configOnlyBorderNearBiomes), new ArrayList<String>(this.configNotBorderNearBiomes));
        for (Integer integer : this.isleInBiomes) {
            clone.isleInBiomes.add((int)integer);
        }
        for (Integer integer : this.borderInBiomes) {
            clone.borderInBiomes.add((int)integer);
        }
        for (Integer integer : this.onlyBorderNearBiomes) {
            clone.onlyBorderNearBiomes.add((int)integer);
        }
        for (Integer integer : this.notBorderNearBiomes) {
            clone.notBorderNearBiomes.add((int)integer);
        }
        return clone;
    }
}

