/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome;

import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ILayerSource;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class CachedBiomeProvider
implements ICachedBiomeProvider {
    static int cacheHits = 0;
    static int smallCacheHits = 0;
    private final ILogger logger;
    private final long seed;
    private final ILayerSource biomeProvider;
    private final IBiome[] biomesById;
    private final Object lock = new Object();
    private boolean locked = false;
    private boolean locked2 = false;
    private final FifoMap<ChunkCoordinate, IBiome[]> biomesCache = new FifoMap(256);
    private final FifoMap<ChunkCoordinate, IBiomeConfig[]> biomeConfigsCache = new FifoMap(256);
    private final Object noiseLock = new Object();
    private final FifoMap<ChunkCoordinate, IBiomeConfig[]> noiseBiomeConfigsCache = new FifoMap(1024);

    public CachedBiomeProvider(long seed, ILayerSource biomeProvider, IBiome[] biomesById, ILogger logger) {
        this.seed = seed;
        this.biomeProvider = biomeProvider;
        this.biomesById = biomesById;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBiomeConfig[] getBiomeConfigsForChunk(ChunkCoordinate chunkCoord) {
        IBiomeConfig[] biomeConfigs;
        Object object = this.lock;
        synchronized (object) {
            this.locked = true;
            biomeConfigs = (IBiomeConfig[])this.biomeConfigsCache.get(chunkCoord);
            if (biomeConfigs == null) {
                IBiome[] biomes = new IBiome[256];
                biomeConfigs = new IBiomeConfig[256];
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        IBiome biome;
                        int biomeId = BiomeInterpolator.getId(this.seed, x + chunkCoord.getBlockX(), 0, z + chunkCoord.getBlockZ(), this.biomeProvider);
                        biomes[x * 16 + z] = biome = this.biomesById[biomeId];
                        biomeConfigs[x * 16 + z] = biome.getBiomeConfig();
                    }
                }
                this.biomesCache.put(chunkCoord, biomes);
                this.biomeConfigsCache.put(chunkCoord, biomeConfigs);
            } else {
                ++cacheHits;
            }
        }
        this.locked = false;
        return biomeConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBiome[] getBiomesForChunk(ChunkCoordinate chunkCoord) {
        IBiome[] biomes;
        Object object = this.lock;
        synchronized (object) {
            this.locked = true;
            biomes = (IBiome[])this.biomesCache.get(chunkCoord);
            if (biomes == null) {
                biomes = new IBiome[256];
                IBiomeConfig[] biomeConfigs = new IBiomeConfig[256];
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        IBiome biome;
                        int biomeId = BiomeInterpolator.getId(this.seed, x + chunkCoord.getBlockX(), 0, z + chunkCoord.getBlockZ(), this.biomeProvider);
                        biomes[x * 16 + z] = biome = this.biomesById[biomeId];
                        biomeConfigs[x * 16 + z] = biome.getBiomeConfig();
                    }
                }
                this.biomesCache.put(chunkCoord, biomes);
                this.biomeConfigsCache.put(chunkCoord, biomeConfigs);
            } else {
                ++cacheHits;
            }
        }
        this.locked = false;
        return biomes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBiome[] getBiomesForChunks(ChunkCoordinate chunkCoord, int widthHeightInBlocks) {
        IBiome[] biomes = new IBiome[widthHeightInBlocks * widthHeightInBlocks];
        int widthHeightInChunks = (int)Math.ceil((float)widthHeightInBlocks / 16.0f);
        Object object = this.lock;
        synchronized (object) {
            this.locked2 = true;
            for (int chunkX = 0; chunkX < widthHeightInChunks; ++chunkX) {
                for (int chunkZ = 0; chunkZ < widthHeightInChunks; ++chunkZ) {
                    IBiome[] chunkBiomes = this.getBiomesForChunk(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + chunkX, chunkCoord.getChunkZ() + chunkZ));
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            biomes[(chunkX * 16 + x) * widthHeightInBlocks + (chunkZ * 16 + z)] = chunkBiomes[x * 16 + z];
                        }
                    }
                }
            }
        }
        this.locked2 = false;
        return biomes;
    }

    @Override
    public IBiomeConfig getBiomeConfig(int x, int z, boolean cacheChunk) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IBiomeConfig[] biomeConfigs = null;
        if (!this.locked && !this.locked2) {
            biomeConfigs = (IBiomeConfig[])this.biomeConfigsCache.get(chunkCoord);
        }
        int internalX = x - chunkCoord.getBlockX();
        int internalZ = z - chunkCoord.getBlockZ();
        if (biomeConfigs == null) {
            if (cacheChunk && !this.locked && !this.locked2) {
                return this.getBiomeConfigsForChunk(chunkCoord)[internalX * 16 + internalZ];
            }
            int biomeId = BiomeInterpolator.getId(this.seed, x, 0, z, this.biomeProvider);
            return this.biomesById[biomeId].getBiomeConfig();
        }
        ++smallCacheHits;
        return biomeConfigs[internalX * 16 + internalZ];
    }

    @Override
    public IBiomeConfig getBiomeConfig(int x, int z) {
        return this.getBiome(x, z).getBiomeConfig();
    }

    @Override
    public IBiome getBiome(int x, int z) {
        return this.biomesById[BiomeInterpolator.getId(this.seed, x, 0, z, this.biomeProvider)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBiomeConfig[] getNoiseBiomeConfigsForRegion(int noiseStartX, int noiseStartZ, int widthHeight) {
        int cacheZ;
        int cacheX;
        int z;
        int x;
        IBiomeConfig[] region;
        int regionSize = 8;
        int regionStartX = noiseStartX >> 3;
        int regionStartZ = noiseStartZ >> 3;
        int cacheOffsetX = noiseStartX - (regionStartX << 3);
        int cacheOffsetZ = noiseStartZ - (regionStartZ << 3);
        int regionWidth = (int)Math.ceil((float)((regionStartX >> 3) + widthHeight - (regionStartX >> 3)) / 8.0f);
        int regionHeight = (int)Math.ceil((float)((regionStartZ >> 3) + widthHeight - (regionStartZ >> 3)) / 8.0f);
        IBiomeConfig[] biomeConfigs = new IBiomeConfig[widthHeight * widthHeight];
        ArrayList<ChunkCoordinate> regionsToHandle = new ArrayList<ChunkCoordinate>();
        Object object = this.noiseLock;
        synchronized (object) {
            for (int regionX = regionStartX; regionX <= regionStartX + regionWidth; ++regionX) {
                for (int regionZ = regionStartZ; regionZ <= regionStartZ + regionHeight; ++regionZ) {
                    ChunkCoordinate regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    region = (IBiomeConfig[])this.noiseBiomeConfigsCache.get(regionCoord);
                    if (region != null) {
                        for (x = 0; x < regionSize; ++x) {
                            for (z = 0; z < regionSize; ++z) {
                                cacheX = (regionX - regionStartX << 3) + x - cacheOffsetX;
                                cacheZ = (regionZ - regionStartZ << 3) + z - cacheOffsetZ;
                                if (cacheX >= widthHeight || cacheX < 0 || cacheZ >= widthHeight || cacheZ < 0) continue;
                                biomeConfigs[cacheX * widthHeight + cacheZ] = region[(x << 3) + z];
                                if (cacheX != widthHeight - 1 || cacheZ != widthHeight - 1 || regionsToHandle.size() != 0) continue;
                                return biomeConfigs;
                            }
                        }
                        continue;
                    }
                    regionsToHandle.add(regionCoord);
                }
            }
        }
        HashMap<ChunkCoordinate, IBiomeConfig[]> regionsHandled = new HashMap<ChunkCoordinate, IBiomeConfig[]>();
        for (ChunkCoordinate regionTohandle : regionsToHandle) {
            region = new IBiomeConfig[regionSize * regionSize];
            for (x = 0; x < regionSize; ++x) {
                for (z = 0; z < regionSize; ++z) {
                    IBiome biome = this.biomesById[this.biomeProvider.getSampler().sample((regionTohandle.getChunkX() << 3) + x, (regionTohandle.getChunkZ() << 3) + z)];
                    region[(x << 3) + z] = biome.getBiomeConfig();
                    cacheX = (regionTohandle.getChunkX() - regionStartX << 3) + x - cacheOffsetX;
                    cacheZ = (regionTohandle.getChunkZ() - regionStartZ << 3) + z - cacheOffsetZ;
                    if (cacheX >= widthHeight || cacheX < 0 || cacheZ >= widthHeight || cacheZ < 0) continue;
                    biomeConfigs[cacheX * widthHeight + cacheZ] = biome.getBiomeConfig();
                }
            }
            regionsHandled.put(regionTohandle, region);
        }
        Object object2 = this.noiseLock;
        synchronized (object2) {
            this.noiseBiomeConfigsCache.putAll(regionsHandled);
        }
        return biomeConfigs;
    }

    @Override
    public IBiomeConfig getNoiseBiomeConfig(int noiseX, int noiseZ, boolean cacheChunk) {
        return this.getNoiseBiome(noiseX, noiseZ, cacheChunk).getBiomeConfig();
    }

    @Override
    public IBiome getNoiseBiome(int noiseX, int noiseZ) {
        return this.getNoiseBiome(noiseX, noiseZ, false);
    }

    private IBiome getNoiseBiome(int noiseX, int noiseZ, boolean cacheChunk) {
        return this.biomesById[this.biomeProvider.getSampler().sample(noiseX, noiseZ)];
    }

    private static class BiomeInterpolator {
        private BiomeInterpolator() {
        }

        public static int getId(long seed, int x, int y, int z, ILayerSource biomeProvider) {
            long pos = BiomeInterpolator.sample(seed, x, y, z);
            int biomeId = biomeProvider.getSampler().sample(MathHelper.getXFromLong(pos), MathHelper.getZFromLong(pos));
            return biomeId;
        }

        private static long sample(long seed, int x, int y, int z) {
            int startX = x - 2;
            int startY = y - 2;
            int startZ = z - 2;
            int chunkX = startX >> 2;
            int chunkY = startY >> 2;
            int chunkZ = startZ >> 2;
            double localX = (double)(startX & 3) / 4.0;
            double localY = (double)(startY & 3) / 4.0;
            double localZ = (double)(startZ & 3) / 4.0;
            double maxDistance = Double.MAX_VALUE;
            int idx = Integer.MIN_VALUE;
            for (int i = 0; i < 8; ++i) {
                double zFraction;
                double yFraction;
                double xFraction;
                boolean isZ;
                int lerpZ;
                boolean isY;
                int lerpY;
                boolean isX = (i & 4) == 0;
                int lerpX = isX ? chunkX : chunkX + 1;
                double distance = BiomeInterpolator.calcSquaredDistance(seed, lerpX, lerpY = (isY = (i & 2) == 0) ? chunkY : chunkY + 1, lerpZ = (isZ = (i & 1) == 0) ? chunkZ : chunkZ + 1, xFraction = isX ? localX : localX - 1.0, yFraction = isY ? localY : localY - 1.0, zFraction = isZ ? localZ : localZ - 1.0);
                if (!(maxDistance > distance)) continue;
                maxDistance = distance;
                idx = i;
            }
            int finalX = (idx & 4) == 0 ? chunkX : chunkX + 1;
            int finalZ = (idx & 1) == 0 ? chunkZ : chunkZ + 1;
            return MathHelper.toLong(finalX, finalZ);
        }

        private static double calcSquaredDistance(long seed, int x, int y, int z, double xFraction, double yFraction, double zFraction) {
            long mixedSeed = MathHelper.mixSeed(seed, x);
            mixedSeed = MathHelper.mixSeed(mixedSeed, y);
            mixedSeed = MathHelper.mixSeed(mixedSeed, z);
            mixedSeed = MathHelper.mixSeed(mixedSeed, x);
            mixedSeed = MathHelper.mixSeed(mixedSeed, y);
            mixedSeed = MathHelper.mixSeed(mixedSeed, z);
            double xOffset = BiomeInterpolator.distribute(mixedSeed);
            mixedSeed = MathHelper.mixSeed(mixedSeed, seed);
            double yOffset = BiomeInterpolator.distribute(mixedSeed);
            mixedSeed = MathHelper.mixSeed(mixedSeed, seed);
            double zOffset = BiomeInterpolator.distribute(mixedSeed);
            return BiomeInterpolator.square(zFraction + zOffset) + BiomeInterpolator.square(yFraction + yOffset) + BiomeInterpolator.square(xFraction + xOffset);
        }

        private static double distribute(long seed) {
            double d = (double)((int)(seed >> 24) & 0x3FF) / 1024.0;
            return (d - 0.5) * 0.9;
        }

        private static double square(double d) {
            return d * d;
        }
    }
}

