/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.gen.biome.BiomeData;
import com.pg85.otg.gen.biome.layers.BiomeLayerBase;
import com.pg85.otg.gen.biome.layers.BiomeLayerData;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import com.pg85.otg.interfaces.ILayerSampler;
import java.util.ArrayList;
import java.util.Arrays;

class BeforeGroupsLayer
extends BiomeLayerBase {
    private final NewBiomeGroup normalGroup;
    private final NewBiomeGroup iceGroup;

    BeforeGroupsLayer(BiomeLayerData data, int depth) {
        super(data, depth);
        int t;
        NewBiomeGroup configNormalGroup = this.data.groupRegistry.get(1);
        NewBiomeGroup configIceGroup = this.data.groupRegistry.get(2);
        this.normalGroup = new NewBiomeGroup();
        this.iceGroup = new NewBiomeGroup();
        ArrayList<BiomeData> normalBiomes = new ArrayList<BiomeData>();
        ArrayList<BiomeData> iceBiomes = new ArrayList<BiomeData>();
        for (BiomeData biome : configNormalGroup.biomes) {
            if (biome.biomeSize != depth) continue;
            for (t = 0; t < biome.rarity; ++t) {
                normalBiomes.add(biome);
            }
            configNormalGroup.totalGroupRarity -= biome.rarity;
        }
        if (!normalBiomes.isEmpty()) {
            this.normalGroup.biomes = Arrays.asList(normalBiomes.toArray(new BiomeData[normalBiomes.size() + configNormalGroup.totalGroupRarity]));
        }
        for (BiomeData biome : configIceGroup.biomes) {
            if (biome.biomeSize != depth) continue;
            for (t = 0; t < biome.rarity; ++t) {
                iceBiomes.add(biome);
            }
            configIceGroup.totalGroupRarity -= biome.rarity;
        }
        if (!iceBiomes.isEmpty()) {
            this.iceGroup.biomes = Arrays.asList(iceBiomes.toArray(new BiomeData[iceBiomes.size() + configIceGroup.totalGroupRarity]));
        }
    }

    @Override
    public int sample(LayerSampleContext<?> context, ILayerSampler parent, int x, int z) {
        int sample = parent.sample(x, z);
        if ((sample & 0xFFFFF) == 0) {
            BiomeData biomeData = null;
            if (this.normalGroup.biomes.size() > 0 && (sample & 0x40000000) == 0) {
                biomeData = this.normalGroup.biomes.get(context.nextInt(this.normalGroup.biomes.size()));
            }
            if (this.iceGroup.biomes.size() > 0 && (sample & 0x40000000) != 0) {
                biomeData = this.iceGroup.biomes.get(context.nextInt(this.iceGroup.biomes.size()));
            }
            if (biomeData != null) {
                return sample | biomeData.id | ((double)biomeData.biomeTemperature <= this.data.frozenOceanTemperature ? 0x40000000 : 0);
            }
        }
        return sample;
    }
}

