/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.gen.biome.layers.BiomeLayers;
import com.pg85.otg.gen.biome.layers.type.ParentedLayer;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import com.pg85.otg.interfaces.ILayerSampler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BiomeBorderLayer
implements ParentedLayer {
    private final BorderedBiome[] borderedBiomes;

    public BiomeBorderLayer(BordersList borderBiomes) {
        this.borderedBiomes = borderBiomes.borderedBiomes;
    }

    @Override
    public int sample(LayerSampleContext<?> context, ILayerSampler parent, int x, int z) {
        int center = parent.sample(x, z);
        int cCheck = BiomeLayers.getBiomeFromLayer(center);
        if (this.borderedBiomes[cCheck] != null) {
            int northCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x, z - 1));
            int southCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x + 1, z));
            int eastCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x, z + 1));
            int westCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x - 1, z));
            int nwCheck = 0;
            int neCheck = 0;
            int swCheck = 0;
            int seCheck = 0;
            boolean bDiagonalCheckDone = false;
            for (BorderBiome borderBiome : this.borderedBiomes[cCheck].biomeBorders) {
                if (!borderBiome.allowedNearBiomes[northCheck] || !borderBiome.allowedNearBiomes[eastCheck] || !borderBiome.allowedNearBiomes[westCheck] || !borderBiome.allowedNearBiomes[southCheck]) continue;
                if (northCheck != cCheck || eastCheck != cCheck || westCheck != cCheck || southCheck != cCheck) {
                    return center & 0x78000000 | Integer.MIN_VALUE | borderBiome.id;
                }
                if (!bDiagonalCheckDone) {
                    nwCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x - 1, z - 1));
                    neCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x + 1, z - 1));
                    swCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x - 1, z + 1));
                    seCheck = BiomeLayers.getBiomeFromLayer(parent.sample(x + 1, z + 1));
                    bDiagonalCheckDone = true;
                }
                if (!borderBiome.allowedNearBiomes[nwCheck] || !borderBiome.allowedNearBiomes[neCheck] || !borderBiome.allowedNearBiomes[swCheck] || !borderBiome.allowedNearBiomes[seCheck] || nwCheck == cCheck && neCheck == cCheck && swCheck == cCheck && seCheck == cCheck) continue;
                return center & 0x78000000 | Integer.MIN_VALUE | borderBiome.id;
            }
        }
        return center;
    }

    public static class BordersList {
        private final BorderedBiome[] borderedBiomes = new BorderedBiome[1024];

        public void addBorder(int biomeId, int borderedBiomeId, List<Integer> onlyBorderNearBiomes, List<Integer> notBorderNearBiomes) {
            BorderedBiome borderedBiome = this.borderedBiomes[borderedBiomeId];
            if (borderedBiome == null) {
                this.borderedBiomes[borderedBiomeId] = borderedBiome = new BorderedBiome();
            }
            boolean[] allowedNearBiomes = new boolean[1024];
            if (onlyBorderNearBiomes != null && onlyBorderNearBiomes.size() > 0) {
                Arrays.fill(allowedNearBiomes, false);
                allowedNearBiomes[biomeId] = true;
                allowedNearBiomes[borderedBiomeId] = true;
                for (int onlyBorderNearBiome : onlyBorderNearBiomes) {
                    allowedNearBiomes[onlyBorderNearBiome] = true;
                }
            } else {
                Arrays.fill(allowedNearBiomes, true);
                for (int notBorderNearBiome : notBorderNearBiomes) {
                    allowedNearBiomes[notBorderNearBiome] = false;
                }
            }
            BorderBiome borderBiome = new BorderBiome(biomeId, allowedNearBiomes);
            borderedBiome.biomeBorders.add(borderBiome);
        }
    }

    private static class BorderedBiome {
        private final ArrayList<BorderBiome> biomeBorders = new ArrayList();

        private BorderedBiome() {
        }
    }

    private static class BorderBiome {
        private final int id;
        private final boolean[] allowedNearBiomes;

        private BorderBiome(int id, boolean[] allowedNearBiomes) {
            this.id = id;
            this.allowedNearBiomes = allowedNearBiomes;
        }
    }
}

