/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.gen.biome.layers.BiomeLayerData;
import com.pg85.otg.gen.biome.layers.BiomeLayers;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.gen.biome.layers.type.ParentedLayer;
import com.pg85.otg.gen.biome.layers.util.LayerRandomnessSource;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import com.pg85.otg.interfaces.ILayerSampler;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class BiomeGroupLayer
implements ParentedLayer {
    private final TreeMap<Integer, NewBiomeGroup> rarityMap = new TreeMap();
    private final int maxRarity;

    BiomeGroupLayer(BiomeLayerData data, int depth) {
        List<NewBiomeGroup> groups = data.groups.get(depth);
        this.maxRarity = data.oldGroupRarity ? data.oldMaxRarities[depth] : data.groupMaxRarityPerDepth[depth];
        int cumulativeRarity = 0;
        for (NewBiomeGroup group : groups) {
            this.rarityMap.put(cumulativeRarity += group.rarity, group);
        }
    }

    @Override
    public int sample(LayerSampleContext<?> context, ILayerSampler parent, int x, int z) {
        NewBiomeGroup biomeGroup;
        int sample = parent.sample(x, z);
        if (BiomeLayers.isLand(sample) && (sample & 0x7F00000) == 0 && (biomeGroup = this.getGroup(context)) != null) {
            return sample | biomeGroup.id << 20;
        }
        return sample;
    }

    private NewBiomeGroup getGroup(LayerRandomnessSource random) {
        int chosenRarity = random.nextInt(this.maxRarity);
        for (Map.Entry<Integer, NewBiomeGroup> entry : this.rarityMap.entrySet()) {
            if (chosenRarity >= entry.getKey()) continue;
            return entry.getValue();
        }
        return null;
    }
}

