/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.gen.biome.layers.BiomeLayers;
import com.pg85.otg.gen.biome.layers.type.DiagonalCrossSamplingLayer;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import java.util.ArrayList;
import java.util.List;

public class BiomeIsleLayer
implements DiagonalCrossSamplingLayer {
    private final IslesList isleBiomes;

    public BiomeIsleLayer(IslesList isleBiomes) {
        this.isleBiomes = isleBiomes;
    }

    @Override
    public int sample(LayerSampleContext<?> context, int x, int z, int sw, int se, int ne, int nw, int center) {
        int sample = center;
        for (Isle isle : this.isleBiomes.getIsles()) {
            int seCheck;
            int swCheck;
            int neCheck;
            int nwCheck;
            boolean alreadySpawned = false;
            if (isle.inOcean) {
                nwCheck = nw & Integer.MIN_VALUE;
                neCheck = ne & Integer.MIN_VALUE;
                swCheck = sw & Integer.MIN_VALUE;
                seCheck = se & Integer.MIN_VALUE;
                if ((center & Integer.MIN_VALUE) == 0 && nwCheck == 0 && neCheck == 0 && swCheck == 0 && seCheck == 0 && context.nextInt(isle.chance) == 0) {
                    sample = sample & 0x40000000 | sample & 0x18000000 | Integer.MIN_VALUE | isle.biomeId | 0x20000000;
                    alreadySpawned = true;
                }
            }
            if (alreadySpawned) continue;
            int centerCheck = BiomeLayers.getBiomeFromLayer(center);
            nwCheck = BiomeLayers.getBiomeFromLayer(nw);
            neCheck = BiomeLayers.getBiomeFromLayer(ne);
            swCheck = BiomeLayers.getBiomeFromLayer(sw);
            seCheck = BiomeLayers.getBiomeFromLayer(se);
            if (!isle.canSpawnIn[centerCheck] || !isle.canSpawnIn[nwCheck] || !isle.canSpawnIn[neCheck] || !isle.canSpawnIn[swCheck] || !isle.canSpawnIn[seCheck] || context.nextInt(isle.chance) != 0) continue;
            sample = sample & Integer.MIN_VALUE | sample & 0x40000000 | sample & 0x18000000 | isle.biomeId | 0x20000000;
        }
        return sample;
    }

    private static class Isle {
        int biomeId;
        int chance = 10;
        boolean[] canSpawnIn = new boolean[1024];
        boolean inOcean = false;

        private Isle() {
        }
    }

    public static class IslesList {
        private List<Isle> isles = new ArrayList<Isle>();

        public List<Isle> getIsles() {
            return this.isles;
        }

        public void addIsle(int biome, int chance, boolean[] biomeCanSpawnIn, boolean inOcean) {
            Isle isle = new Isle();
            isle.biomeId = biome;
            isle.chance = chance;
            isle.canSpawnIn = biomeCanSpawnIn;
            isle.inOcean = inOcean;
            this.isles.add(isle);
        }
    }
}

