/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.gen.biome.BiomeData;
import com.pg85.otg.gen.biome.layers.BiomeLayerBase;
import com.pg85.otg.gen.biome.layers.BiomeLayerData;
import com.pg85.otg.gen.biome.layers.BiomeLayers;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.gen.biome.layers.util.LayerRandomnessSource;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import com.pg85.otg.interfaces.ILayerSampler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class BiomeLayer
extends BiomeLayerBase {
    protected final Map<NewBiomeGroup, Map<Integer, BiomeData>> groupBiomes = new HashMap<NewBiomeGroup, Map<Integer, BiomeData>>();

    BiomeLayer(BiomeLayerData data, int depth) {
        super(data, depth);
        for (Map.Entry<Integer, List<NewBiomeGroup>> entry : data.groups.entrySet()) {
            for (NewBiomeGroup group : entry.getValue()) {
                int cumulativeRarity = 0;
                TreeMap<Integer, BiomeData> biomes = new TreeMap<Integer, BiomeData>();
                for (BiomeData biome : group.biomes) {
                    if (depth != biome.biomeSize) continue;
                    biomes.put(cumulativeRarity += biome.rarity, biome);
                }
                if (cumulativeRarity <= 0) continue;
                this.groupBiomes.put(group, biomes);
            }
        }
    }

    @Override
    public int sample(LayerSampleContext<?> context, ILayerSampler parent, int x, int z) {
        int biomeGroupId;
        int sample = parent.sample(x, z);
        if ((sample & 0x7F00000) != 0 && (sample & 0xFFFFF) == 0 && (biomeGroupId = BiomeLayers.getGroupId(sample)) > 0) {
            NewBiomeGroup group = this.data.groupRegistry.get(biomeGroupId);
            if (group.maxRarityPerDepth[this.depth] != 0 && this.groupBiomes.containsKey(group)) {
                BiomeData biomeData = this.getBiomeFromGroup(context, group.maxRarityPerDepth[this.depth], this.groupBiomes.get(group));
                return sample | biomeData.id | ((double)biomeData.biomeTemperature <= this.data.frozenOceanTemperature ? 0x40000000 : 0);
            }
        }
        return sample;
    }

    private BiomeData getBiomeFromGroup(LayerRandomnessSource random, int maxRarity, Map<Integer, BiomeData> rarityMap) {
        int chosenRarity = random.nextInt(maxRarity);
        for (Map.Entry<Integer, BiomeData> entry : rarityMap.entrySet()) {
            if (chosenRarity >= entry.getKey()) continue;
            return entry.getValue();
        }
        return this.data.oceanBiomeData;
    }
}

