/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.google.common.collect.ImmutableList;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.gen.biome.BiomeData;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BiomeLayerData {
    public final SettingsEnums.BiomeMode biomeMode;
    public final int generationDepth;
    public final int landSize;
    public final int landFuzzy;
    public final int landRarity;
    public boolean forceLandAtSpawn;
    public final int oceanBiomeSize;
    public final int[] oceanTemperatures;
    public final double frozenOceanTemperature;
    public final int biomeRarityScale;
    public final BiomeData oceanBiomeData;
    public final Map<Integer, List<NewBiomeGroup>> groups = new HashMap<Integer, List<NewBiomeGroup>>();
    private final int[] cumulativeGroupRarities;
    public final int[] groupMaxRarityPerDepth;
    public final int[] oldMaxRarities;
    public final boolean oldGroupRarity;
    public final boolean oldLandRarity;
    public final List<Integer> biomeDepths = new ArrayList<Integer>();
    public final Map<Integer, NewBiomeGroup> groupRegistry = new HashMap<Integer, NewBiomeGroup>();
    public final Map<Integer, List<BiomeData>> isleBiomesAtDepth = new HashMap<Integer, List<BiomeData>>();
    public final Map<Integer, List<BiomeData>> borderBiomesAtDepth = new HashMap<Integer, List<BiomeData>>();
    public int[] riverBiomes;
    public final boolean riversEnabled;
    public final boolean randomRivers;
    public final int riverDepth;
    public final int riverSize;
    public HashMap<Integer, Integer> biomeColorMap;
    public final int imageXOffset;
    public final int imageZOffset;
    public final SettingsEnums.ImageMode imageMode;
    public final String configImageFillBiome;
    public int imageFillBiome;
    public final Path presetDir;
    public final String imageFile;
    public final SettingsEnums.ImageOrientation imageOrientation;

    public BiomeLayerData(BiomeLayerData data) {
        ArrayList<Object> clonedList;
        this.biomeColorMap = new HashMap();
        for (Map.Entry<Integer, Integer> entry : data.biomeColorMap.entrySet()) {
            this.biomeColorMap.put((int)entry.getKey(), (int)entry.getValue());
        }
        this.imageXOffset = data.imageXOffset;
        this.imageZOffset = data.imageZOffset;
        this.imageMode = data.imageMode;
        this.configImageFillBiome = data.configImageFillBiome;
        this.imageFillBiome = data.imageFillBiome;
        this.presetDir = data.presetDir;
        this.imageFile = data.imageFile;
        this.imageOrientation = data.imageOrientation;
        this.biomeMode = data.biomeMode;
        this.generationDepth = data.generationDepth;
        this.landSize = data.landSize;
        this.landFuzzy = data.landFuzzy;
        this.landRarity = data.landRarity;
        this.oceanBiomeSize = data.oceanBiomeSize;
        this.frozenOceanTemperature = data.frozenOceanTemperature;
        this.biomeRarityScale = data.biomeRarityScale;
        this.randomRivers = data.randomRivers;
        this.riverDepth = data.riverDepth;
        this.riverSize = data.riverSize;
        this.riversEnabled = data.riversEnabled;
        this.oceanBiomeData = data.oceanBiomeData.clone();
        this.biomeDepths.addAll(data.biomeDepths);
        this.cumulativeGroupRarities = (int[])data.cumulativeGroupRarities.clone();
        this.groupMaxRarityPerDepth = (int[])data.groupMaxRarityPerDepth.clone();
        this.oldMaxRarities = data.oldMaxRarities;
        this.oldGroupRarity = data.oldGroupRarity;
        this.oldLandRarity = data.oldLandRarity;
        this.forceLandAtSpawn = data.forceLandAtSpawn;
        for (Map.Entry<Integer, Object> entry : data.groups.entrySet()) {
            if (entry.getValue() != null) {
                clonedList = new ArrayList<Object>();
                for (NewBiomeGroup group : (List)entry.getValue()) {
                    NewBiomeGroup clonedGroup = group.clone();
                    this.groupRegistry.put(clonedGroup.id, clonedGroup);
                    clonedList.add(clonedGroup);
                }
                this.groups.put((int)entry.getKey(), clonedList);
                continue;
            }
            this.groups.put((int)entry.getKey(), null);
        }
        for (Map.Entry<Integer, Object> entry : data.isleBiomesAtDepth.entrySet()) {
            if (entry.getValue() != null) {
                clonedList = new ArrayList();
                for (BiomeData biome : (List)entry.getValue()) {
                    clonedList.add(biome.clone());
                }
                this.isleBiomesAtDepth.put((int)entry.getKey(), clonedList);
                continue;
            }
            this.isleBiomesAtDepth.put((int)entry.getKey(), null);
        }
        for (Map.Entry<Integer, Object> entry : data.borderBiomesAtDepth.entrySet()) {
            if (entry.getValue() != null) {
                clonedList = new ArrayList();
                for (BiomeData biome : (List)entry.getValue()) {
                    clonedList.add(biome.clone());
                }
                this.borderBiomesAtDepth.put((int)entry.getKey(), clonedList);
                continue;
            }
            this.borderBiomesAtDepth.put((int)entry.getKey(), null);
        }
        this.riverBiomes = (int[])data.riverBiomes.clone();
        this.oceanTemperatures = new int[4];
        System.arraycopy(data.oceanTemperatures, 0, this.oceanTemperatures, 0, 4);
    }

    public BiomeLayerData(Path presetDir, IWorldConfig worldConfig, IBiomeConfig oceanBiomeConfig, int[] oceanTemperatures) {
        this.imageXOffset = worldConfig.getImageXOffset();
        this.imageZOffset = worldConfig.getImageZOffset();
        this.imageMode = worldConfig.getImageMode();
        this.configImageFillBiome = worldConfig.getImageFillBiome();
        this.presetDir = presetDir;
        this.imageFile = worldConfig.getImageFile();
        this.imageOrientation = worldConfig.getImageOrientation();
        this.biomeMode = worldConfig.getBiomeMode();
        this.generationDepth = worldConfig.getGenerationDepth();
        this.landSize = worldConfig.getLandSize();
        this.landFuzzy = worldConfig.getLandFuzzy();
        this.landRarity = worldConfig.getLandRarity();
        this.oceanBiomeSize = worldConfig.getOceanBiomeSize();
        this.oceanTemperatures = oceanTemperatures;
        this.cumulativeGroupRarities = new int[this.generationDepth + 1];
        this.groupMaxRarityPerDepth = new int[this.generationDepth + 1];
        this.oldMaxRarities = new int[this.generationDepth + 1];
        this.oldGroupRarity = worldConfig.getOldGroupRarity();
        this.oldLandRarity = worldConfig.getOldLandRarity();
        this.forceLandAtSpawn = worldConfig.getForceLandAtSpawn();
        this.oceanBiomeData = oceanBiomeConfig == null ? new BiomeData(0, 0, 0, 0.0f, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of()) : new BiomeData(0, oceanBiomeConfig.getBiomeRarity(), oceanBiomeConfig.getBiomeSize(), oceanBiomeConfig.getBiomeTemperature(), oceanBiomeConfig.getIsleInBiomes(), oceanBiomeConfig.getBorderInBiomes(), oceanBiomeConfig.getOnlyBorderNearBiomes(), oceanBiomeConfig.getNotBorderNearBiomes());
        this.frozenOceanTemperature = worldConfig.getFrozenOceanTemperature();
        this.biomeRarityScale = worldConfig.getBiomeRarityScale();
        this.randomRivers = worldConfig.getIsRandomRivers();
        this.riverDepth = worldConfig.getRiverRarity();
        this.riverSize = worldConfig.getRiverSize();
        this.riversEnabled = worldConfig.getRiversEnabled();
    }

    public void init(Set<Integer> biomeDepths, Map<Integer, List<NewBiomeGroup>> groupDepth, Map<Integer, List<BiomeData>> isleBiomesAtDepth, Map<Integer, List<BiomeData>> borderBiomesAtDepth, Map<String, List<Integer>> biomeIdsByName, HashMap<Integer, Integer> biomeColorMap, IBiome[] biomes) {
        this.biomeDepths.addAll(biomeDepths);
        this.groups.putAll(groupDepth);
        this.isleBiomesAtDepth.putAll(isleBiomesAtDepth);
        this.borderBiomesAtDepth.putAll(borderBiomesAtDepth);
        for (Map.Entry<Integer, List<NewBiomeGroup>> entry : this.groups.entrySet()) {
            if (entry.getValue() == null) continue;
            int cumulativeRarity = 0;
            for (NewBiomeGroup group : entry.getValue()) {
                group.init(biomeIdsByName);
                cumulativeRarity += group.rarity;
                int n = entry.getKey();
                this.oldMaxRarities[n] = this.oldMaxRarities[n] + 1;
            }
            this.cumulativeGroupRarities[entry.getKey().intValue()] = cumulativeRarity;
        }
        for (int depth = 0; depth < this.cumulativeGroupRarities.length; ++depth) {
            for (int j = depth; j < this.cumulativeGroupRarities.length; ++j) {
                int n = depth;
                this.groupMaxRarityPerDepth[n] = this.groupMaxRarityPerDepth[n] + this.cumulativeGroupRarities[j];
            }
        }
        int i = 0;
        while (i < this.oldMaxRarities.length) {
            int n = i++;
            this.oldMaxRarities[n] = this.oldMaxRarities[n] * 100;
        }
        for (Map.Entry<Integer, List<BiomeData>> entry : this.isleBiomesAtDepth.entrySet()) {
            if (entry.getValue() == null) continue;
            for (BiomeData biome : entry.getValue()) {
                biome.init(biomeIdsByName);
            }
        }
        for (Map.Entry<Integer, List<BiomeData>> entry : this.borderBiomesAtDepth.entrySet()) {
            if (entry.getValue() == null) continue;
            for (BiomeData biome : entry.getValue()) {
                biome.init(biomeIdsByName);
            }
        }
        this.biomeColorMap = biomeColorMap;
        this.riverBiomes = new int[biomes.length];
        for (i = 0; i < biomes.length; ++i) {
            List ids = biomeIdsByName.getOrDefault(biomes[i].getBiomeConfig().getRiverBiome(), null);
            this.riverBiomes[i] = ids == null ? -1 : (Integer)ids.get(0);
        }
    }
}

