/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.gen.biome.BiomeData;
import com.pg85.otg.gen.biome.layers.AddIslandsLayer;
import com.pg85.otg.gen.biome.layers.BeforeGroupsLayer;
import com.pg85.otg.gen.biome.layers.BiomeBorderLayer;
import com.pg85.otg.gen.biome.layers.BiomeGroupLayer;
import com.pg85.otg.gen.biome.layers.BiomeIsleLayer;
import com.pg85.otg.gen.biome.layers.BiomeLayer;
import com.pg85.otg.gen.biome.layers.BiomeLayerData;
import com.pg85.otg.gen.biome.layers.FinalizeLayer;
import com.pg85.otg.gen.biome.layers.FinalizeWithRiverLayer;
import com.pg85.otg.gen.biome.layers.FromImageLayer;
import com.pg85.otg.gen.biome.layers.FuzzyScaleLayer;
import com.pg85.otg.gen.biome.layers.IceLayer;
import com.pg85.otg.gen.biome.layers.InitializationLayer;
import com.pg85.otg.gen.biome.layers.LandLayer;
import com.pg85.otg.gen.biome.layers.MergeOceanTemperatureLayer;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.gen.biome.layers.OceanTemperatureLayer;
import com.pg85.otg.gen.biome.layers.RiverInitLayer;
import com.pg85.otg.gen.biome.layers.RiverLayer;
import com.pg85.otg.gen.biome.layers.ScaleLayer;
import com.pg85.otg.gen.biome.layers.util.CachingLayerContext;
import com.pg85.otg.gen.biome.layers.util.CachingLayerSampler;
import com.pg85.otg.gen.biome.layers.util.LayerFactory;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import com.pg85.otg.interfaces.ILayerSampler;
import com.pg85.otg.interfaces.ILogger;
import java.util.List;
import java.util.function.LongFunction;

public class BiomeLayers {
    protected static final int LAND_BIT = Integer.MIN_VALUE;
    protected static final int ICE_BIT = 0x40000000;
    protected static final int ISLAND_BIT = 0x20000000;
    private static final int RIVER_SHIFT = 27;
    protected static final int RIVER_BITS = 0x18000000;
    protected static final int RIVER_BIT_ONE = 0x8000000;
    protected static final int RIVER_BIT_TWO = 0x10000000;
    protected static final int GROUP_SHIFT = 20;
    protected static final int GROUP_BITS = 0x7F00000;
    protected static final int BIOME_BITS = 1048575;

    static boolean isLand(int sample) {
        return (sample & Integer.MIN_VALUE) != 0;
    }

    static int getGroupId(int sample) {
        return (sample & 0x7F00000) >> 20;
    }

    static int getBiomeFromLayer(int sample) {
        return (sample & Integer.MIN_VALUE) != 0 ? sample & 0xFFFFF : 0;
    }

    private static <T extends ILayerSampler, C extends LayerSampleContext<T>> LayerFactory<T> build(BiomeLayerData data, LongFunction<C> contextProvider, ILogger logger) {
        LayerFactory factory = new InitializationLayer().create((LayerSampleContext)contextProvider.apply(1L));
        LayerFactory riverFactory = new InitializationLayer().create((LayerSampleContext)contextProvider.apply(1L));
        LayerFactory oceanTemperatureFactory = null;
        boolean riversStarted = false;
        boolean oceanTemperatureStarted = false;
        if (data.biomeMode != SettingsEnums.BiomeMode.FromImage || data.imageMode == SettingsEnums.ImageMode.ContinueNormal) {
            for (int depth = 0; depth <= data.generationDepth; ++depth) {
                List<BiomeData> borderBiomes;
                List<BiomeData> isleBiomes;
                factory = new ScaleLayer().create((LayerSampleContext)contextProvider.apply(2000L + (long)depth), factory);
                if (data.randomRivers && riversStarted) {
                    riverFactory = new ScaleLayer().create((LayerSampleContext)contextProvider.apply(2000L + (long)depth), riverFactory);
                }
                if (oceanTemperatureStarted) {
                    oceanTemperatureFactory = new ScaleLayer().create((LayerSampleContext)contextProvider.apply(2000L + (long)depth), oceanTemperatureFactory);
                }
                if (depth == data.landSize && data.landRarity > 0) {
                    factory = new LandLayer(data.landRarity, data.forceLandAtSpawn, data.oldLandRarity).create((LayerSampleContext)contextProvider.apply(1L), factory);
                    factory = new FuzzyScaleLayer().create((LayerSampleContext)contextProvider.apply(2000L), factory);
                }
                if (depth == data.oceanBiomeSize) {
                    oceanTemperatureFactory = new OceanTemperatureLayer(data).create((LayerSampleContext)contextProvider.apply(3L));
                    oceanTemperatureStarted = true;
                }
                if (depth < data.landSize + data.landFuzzy) {
                    factory = new AddIslandsLayer().create((LayerSampleContext)contextProvider.apply(depth), factory);
                }
                if (data.biomeMode == SettingsEnums.BiomeMode.Normal || data.biomeMode == SettingsEnums.BiomeMode.FromImage) {
                    if (data.groups.containsKey(depth)) {
                        factory = new BiomeGroupLayer(data, depth).create((LayerSampleContext)contextProvider.apply(depth), factory);
                    }
                    if (data.biomeDepths.contains(depth)) {
                        factory = new BiomeLayer(data, depth).create((LayerSampleContext)contextProvider.apply(depth), factory);
                    }
                    if (depth == 3) {
                        factory = new IceLayer(data).create((LayerSampleContext)contextProvider.apply(depth), factory);
                    }
                } else if (data.biomeMode == SettingsEnums.BiomeMode.NoGroups) {
                    NewBiomeGroup iceGroup;
                    if (data.biomeDepths.contains(depth)) {
                        factory = new BeforeGroupsLayer(data, depth).create((LayerSampleContext)contextProvider.apply(depth), factory);
                    }
                    if ((iceGroup = data.groupRegistry.get(2)) != null) {
                        factory = new IceLayer(data).create((LayerSampleContext)contextProvider.apply(depth), factory);
                    }
                }
                if (data.riverDepth == depth) {
                    if (data.randomRivers) {
                        riverFactory = new RiverInitLayer().create((LayerSampleContext)contextProvider.apply(depth), riverFactory);
                        riversStarted = true;
                    } else {
                        factory = new RiverInitLayer().create((LayerSampleContext)contextProvider.apply(depth), factory);
                    }
                }
                if (data.generationDepth - data.riverSize == depth) {
                    if (data.randomRivers) {
                        riverFactory = new RiverLayer().create((LayerSampleContext)contextProvider.apply(5 + depth), riverFactory);
                    } else {
                        factory = new RiverLayer().create((LayerSampleContext)contextProvider.apply(5 + depth), factory);
                    }
                }
                if ((isleBiomes = data.isleBiomesAtDepth.get(depth)) != null && isleBiomes.size() > 0) {
                    BiomeIsleLayer.IslesList islesAtCurrentDepth = new BiomeIsleLayer.IslesList();
                    for (BiomeData biome : isleBiomes) {
                        boolean[] biomeCanSpawnIn = new boolean[1024];
                        boolean inOcean = false;
                        for (int islandInBiome : biome.isleInBiomes) {
                            if (islandInBiome == data.oceanBiomeData.id) {
                                inOcean = true;
                                continue;
                            }
                            biomeCanSpawnIn[islandInBiome] = true;
                        }
                        int chance = data.biomeRarityScale + 1 - biome.rarity;
                        islesAtCurrentDepth.addIsle(biome.id, chance, biomeCanSpawnIn, inOcean);
                    }
                    factory = new BiomeIsleLayer(islesAtCurrentDepth).create((LayerSampleContext)contextProvider.apply(depth), factory);
                }
                if ((borderBiomes = data.borderBiomesAtDepth.get(depth)) == null || borderBiomes.size() <= 0) continue;
                BiomeBorderLayer.BordersList bordersAtCurrentDepth = new BiomeBorderLayer.BordersList();
                for (BiomeData biome : borderBiomes) {
                    for (int targetBiomeId : biome.borderInBiomes) {
                        bordersAtCurrentDepth.addBorder(biome.id, targetBiomeId, biome.onlyBorderNearBiomes, biome.notBorderNearBiomes);
                    }
                }
                factory = new BiomeBorderLayer(bordersAtCurrentDepth).create((LayerSampleContext)contextProvider.apply(depth), factory);
            }
            factory = new MergeOceanTemperatureLayer().create((LayerSampleContext)contextProvider.apply(1L), factory, oceanTemperatureFactory);
            factory = data.randomRivers ? new FinalizeWithRiverLayer(data.riversEnabled, data.riverBiomes).create((LayerSampleContext)contextProvider.apply(1L), factory, riverFactory) : new FinalizeLayer(data.riversEnabled, data.riverBiomes).create((LayerSampleContext)contextProvider.apply(1L), factory);
        }
        if (data.biomeMode == SettingsEnums.BiomeMode.FromImage) {
            factory = new FromImageLayer(data, logger).create((LayerSampleContext)contextProvider.apply(0L), factory);
        }
        return factory;
    }

    public static CachingLayerSampler create(long seed, BiomeLayerData data, ILogger logger) {
        LayerFactory factory = BiomeLayers.build(data, salt -> new CachingLayerContext(25, seed, salt), logger);
        return (CachingLayerSampler)factory.make();
    }
}

