/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.biome.layers;

import com.pg85.otg.gen.biome.layers.type.ParentedLayer;
import com.pg85.otg.gen.biome.layers.util.LayerSampleContext;
import com.pg85.otg.interfaces.ILayerSampler;

class LandLayer
implements ParentedLayer {
    private final int rarity;
    private final boolean forceLandAtSpawn;
    private final boolean spawnLand;
    private final boolean oldLandRarity;

    LandLayer(int landRarity, boolean forceLandAtSpawn, boolean oldLandRarity) {
        this.rarity = oldLandRarity ? 101 - landRarity : landRarity;
        this.forceLandAtSpawn = forceLandAtSpawn;
        this.spawnLand = landRarity != 0;
        this.oldLandRarity = oldLandRarity;
    }

    @Override
    public int sample(LayerSampleContext<?> context, ILayerSampler parent, int x, int z) {
        boolean result;
        int sample = parent.sample(x, z);
        if (this.oldLandRarity) {
            result = context.nextInt(this.rarity) == 0;
        } else {
            boolean bl = result = context.nextInt(101) <= this.rarity;
        }
        if (result && this.spawnLand) {
            return sample | Integer.MIN_VALUE;
        }
        if (x == 0 && z == 0 && this.forceLandAtSpawn) {
            return sample | Integer.MIN_VALUE;
        }
        return sample;
    }
}

