/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.carver;

import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ISurfaceGeneratorNoiseProvider;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.MutableBoolean;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.BitSet;
import java.util.Random;

public abstract class Carver {
    protected final int heightLimit;
    protected final IWorldConfig worldConfig;

    public Carver(int heightLimit, IWorldConfig worldConfig) {
        this.heightLimit = heightLimit;
        this.worldConfig = worldConfig;
    }

    public int getBranchFactor() {
        return 4;
    }

    protected boolean carveRegion(ISurfaceGeneratorNoiseProvider noiseProvider, float[] cache, ChunkBuffer chunkBuffer, long seed, int chunkX, int chunkZ, double x, double y, double z, double yaw, double pitch, BitSet carvingMask, ICachedBiomeProvider cachedBiomeProvider) {
        Random random = new Random(seed + (long)chunkX + (long)chunkZ);
        double d = chunkX * 16 + 8;
        double e = chunkZ * 16 + 8;
        IBiomeConfig[] biomeConfigs = cachedBiomeProvider.getBiomeConfigsForChunk(chunkBuffer.getChunkCoordinate());
        if (!(x < d - 16.0 - yaw * 2.0 || z < e - 16.0 - yaw * 2.0 || x > d + 16.0 + yaw * 2.0 || z > e + 16.0 + yaw * 2.0)) {
            int n;
            int m;
            int l;
            int k;
            int j;
            int i = Math.max(MathHelper.floor(x - yaw) - chunkX * 16 - 1, 0);
            if (this.isRegionUncarvable(chunkBuffer, chunkX, chunkZ, i, j = Math.min(MathHelper.floor(x + yaw) - chunkX * 16 + 1, 16), k = Math.max(MathHelper.floor(y - pitch) - 1, 1), l = Math.min(MathHelper.floor(y + pitch) + 1, this.heightLimit - 8), m = Math.max(MathHelper.floor(z - yaw) - chunkZ * 16 - 1, 0), n = Math.min(MathHelper.floor(z + yaw) - chunkZ * 16 + 1, 16))) {
                return false;
            }
            boolean bl = false;
            for (int o = i; o < j; ++o) {
                int worldX = o + chunkX * 16;
                double f = ((double)worldX + 0.5 - x) / yaw;
                for (int q = m; q < n; ++q) {
                    int worldZ = q + chunkZ * 16;
                    IBiomeConfig biomeConfig = biomeConfigs[o * 16 + q];
                    double g = ((double)worldZ + 0.5 - z) / yaw;
                    if (f * f + g * g >= 1.0) continue;
                    MutableBoolean foundSurface = new MutableBoolean(false);
                    for (int s = l; s > k; --s) {
                        double h = ((double)s - 0.5 - y) / pitch;
                        if (this.isPositionExcluded(cache, f, h, g, s)) continue;
                        bl |= this.carveAtPoint(noiseProvider, chunkBuffer, carvingMask, random, biomeConfig.getWaterLevelMax(), chunkX, chunkZ, worldX, worldZ, o, s, q, foundSurface, biomeConfig);
                    }
                }
            }
            return bl;
        }
        return false;
    }

    protected boolean carveAtPoint(ISurfaceGeneratorNoiseProvider noiseProvider, ChunkBuffer chunkBuffer, BitSet carvingMask, Random random, int seaLevel, int mainChunkX, int mainChunkZ, int worldX, int worldZ, int relativeX, int y, int relativeZ, MutableBoolean foundSurface, IBiomeConfig biomeConfig) {
        int i = relativeX | relativeZ << 4 | y << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        LocalMaterialData material = chunkBuffer.getBlock(worldX, y, worldZ);
        if (material.isNonCaveAir() || material.isMaterial(LocalMaterials.WATER)) {
            return false;
        }
        LocalMaterialData blockAbove = chunkBuffer.getBlock(worldX, y + 1, worldZ);
        if (material.isMaterial(biomeConfig.getSurfaceBlockAtHeight(noiseProvider, worldX, y - 1, worldZ))) {
            foundSurface.setValue(true);
        }
        if (material.isSolid() && !blockAbove.isMaterial(LocalMaterials.WATER)) {
            if (y <= this.worldConfig.getCarverLavaBlockHeight()) {
                chunkBuffer.setBlock(worldX, y, worldZ, this.worldConfig.getCarverLavaBlock());
            } else {
                LocalMaterialData blockBelow;
                chunkBuffer.setBlock(worldX, y, worldZ, LocalMaterials.CAVE_AIR);
                if (foundSurface.isValue() && (blockBelow = chunkBuffer.getBlock(worldX, y - 1, worldZ)).isMaterial(biomeConfig.getGroundBlockAtHeight(noiseProvider, worldX, y - 1, worldZ))) {
                    chunkBuffer.setBlock(worldX, y - 1, worldZ, biomeConfig.getSurfaceBlockAtHeight(noiseProvider, worldX, y - 1, worldZ));
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean isRegionUncarvable(ChunkBuffer chunk, int mainChunkX, int mainChunkZ, int relMinX, int relMaxX, int minY, int maxY, int relMinZ, int relMaxZ) {
        for (int i = relMinX; i < relMaxX; ++i) {
            for (int j = relMinZ; j < relMaxZ; ++j) {
                for (int k = minY - 1; k <= maxY + 1; ++k) {
                    if (chunk.getBlock(i + mainChunkX * 16, k, j + mainChunkZ * 16).isMaterial(LocalMaterials.WATER)) {
                        return true;
                    }
                    if (k == maxY + 1 || this.isOnBoundary(relMinX, relMaxX, relMinZ, relMaxZ, i, j)) continue;
                    k = maxY;
                }
            }
        }
        return false;
    }

    private boolean isOnBoundary(int minX, int maxX, int minZ, int maxZ, int x, int z) {
        return x == minX || x == maxX - 1 || z == minZ || z == maxZ - 1;
    }

    protected boolean canCarveBranch(int mainChunkX, int mainChunkZ, double x, double z, int branch, int branchCount, float baseWidth) {
        double d = mainChunkX * 16 + 8;
        double f = x - d;
        double e = mainChunkZ * 16 + 8;
        double g = z - e;
        double h = branchCount - branch;
        double i = baseWidth + 2.0f + 16.0f;
        return f * f + g * g - h * h <= i * i;
    }

    public abstract boolean carve(ISurfaceGeneratorNoiseProvider var1, ChunkBuffer var2, Random var3, int var4, int var5, int var6, int var7, BitSet var8, ICachedBiomeProvider var9);

    public abstract boolean isStartChunk(Random var1, int var2, int var3);

    protected abstract boolean isPositionExcluded(float[] var1, double var2, double var4, double var6, int var8);
}

