/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.carver;

import com.pg85.otg.gen.carver.Carver;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ISurfaceGeneratorNoiseProvider;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.BitSet;
import java.util.Random;

public class CaveCarver
extends Carver {
    public CaveCarver(int heightLimit, IWorldConfig worldConfig) {
        super(heightLimit, worldConfig);
    }

    @Override
    public boolean carve(ISurfaceGeneratorNoiseProvider noiseProvider, ChunkBuffer chunk, Random random, int chunkX, int chunkZ, int mainChunkX, int mainChunkZ, BitSet carvingMask, ICachedBiomeProvider cachedBiomeProvider) {
        int branchFactor = (this.getBranchFactor() * 2 - 1) * 16;
        int caveCount = random.nextInt(random.nextInt(random.nextInt(this.getMaxCaveCount()) + 1) + 1);
        if (this.worldConfig.isEvenCaveDistribution()) {
            caveCount = this.worldConfig.getCaveFrequency();
        }
        for (int cave = 0; cave < caveCount; ++cave) {
            double x = chunkX * 16 + random.nextInt(16);
            double y = this.getCaveY(random);
            double z = chunkZ * 16 + random.nextInt(16);
            int tunnelCount = this.worldConfig.getCaveSystemFrequency();
            if (random.nextInt(100) < this.worldConfig.getIndividualCaveRarity()) {
                float size = 1.0f + random.nextFloat() * 6.0f;
                this.carveCave(noiseProvider, chunk, random.nextLong(), mainChunkX, mainChunkZ, x, y, z, size, 0.5, carvingMask, cachedBiomeProvider);
                tunnelCount += RandomHelper.numberInRange(random, this.worldConfig.getCaveSystemPocketMinSize(), this.worldConfig.getCaveSystemPocketMaxSize());
            } else if (random.nextInt(100) <= this.worldConfig.getCaveSystemPocketChance() - 1) {
                tunnelCount += RandomHelper.numberInRange(random, this.worldConfig.getCaveSystemPocketMinSize(), this.worldConfig.getCaveSystemPocketMaxSize());
            }
            for (int r = 0; r < tunnelCount; ++r) {
                float yaw = random.nextFloat() * ((float)Math.PI * 2);
                float size = (random.nextFloat() - 0.5f) / 4.0f;
                float width = this.getTunnelSystemWidth(random);
                int branchCount = branchFactor - random.nextInt(branchFactor / 4);
                this.carveTunnels(noiseProvider, chunk, random.nextLong(), mainChunkX, mainChunkZ, x, y, z, width, yaw, size, 0, branchCount, this.getTunnelSystemHeightWidthRatio(), carvingMask, cachedBiomeProvider);
            }
        }
        return true;
    }

    @Override
    public boolean isStartChunk(Random random, int chunkX, int chunkZ) {
        if (this.worldConfig.getCaveFrequency() <= 0) {
            return false;
        }
        return random.nextInt(100) < this.worldConfig.getCaveRarity();
    }

    protected int getMaxCaveCount() {
        return this.worldConfig.getCaveFrequency();
    }

    protected float getTunnelSystemWidth(Random random) {
        float width = random.nextFloat() * 2.0f + random.nextFloat();
        if (random.nextInt(10) == 0) {
            width *= random.nextFloat() * random.nextFloat() * 3.0f + 1.0f;
        }
        return width;
    }

    protected double getTunnelSystemHeightWidthRatio() {
        return 1.0;
    }

    protected int getCaveY(Random random) {
        if (this.worldConfig.isEvenCaveDistribution()) {
            return RandomHelper.numberInRange(random, this.worldConfig.getCaveMinAltitude(), this.worldConfig.getCaveMaxAltitude());
        }
        return random.nextInt(random.nextInt(this.worldConfig.getCaveMaxAltitude() - this.worldConfig.getCaveMinAltitude() + 1) + 1) + this.worldConfig.getCaveMinAltitude();
    }

    protected void carveCave(ISurfaceGeneratorNoiseProvider noiseProvider, ChunkBuffer chunk, long seed, int mainChunkX, int mainChunkZ, double x, double y, double z, float yaw, double yawPitchRatio, BitSet carvingMask, ICachedBiomeProvider cachedBiomeProvider) {
        double scaledYaw = 1.5 + (double)(MathHelper.sin(1.5707964f) * yaw);
        double scaledPitch = scaledYaw * yawPitchRatio;
        this.carveRegion(noiseProvider, null, chunk, seed, mainChunkX, mainChunkZ, x + 1.0, y, z, scaledYaw, scaledPitch, carvingMask, cachedBiomeProvider);
    }

    protected void carveTunnels(ISurfaceGeneratorNoiseProvider noiseProvider, ChunkBuffer chunk, long seed, int mainChunkX, int mainChunkZ, double x, double y, double z, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, BitSet carvingMask, ICachedBiomeProvider cachedBiomeProvider) {
        Random random = new Random(seed);
        int nextBranchIndex = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean isBigger = random.nextInt(6) == 0;
        float yawChange = 0.0f;
        float pitchChange = 0.0f;
        for (int branchIndex = branchStartIndex; branchIndex < branchCount; ++branchIndex) {
            double currentYaw = 1.5 + (double)(MathHelper.sin((float)Math.PI * (float)branchIndex / (float)branchCount) * width);
            double currentPitch = currentYaw * yawPitchRatio;
            float delta = MathHelper.cos(pitch);
            x += (double)(MathHelper.cos(yaw) * delta);
            y += (double)MathHelper.sin(pitch);
            z += (double)(MathHelper.sin(yaw) * delta);
            pitch *= isBigger ? 0.92f : 0.7f;
            pitch += pitchChange * 0.1f;
            yaw += yawChange * 0.1f;
            pitchChange *= 0.9f;
            yawChange *= 0.75f;
            pitchChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            yawChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (branchIndex == nextBranchIndex && width > 1.0f) {
                this.carveTunnels(noiseProvider, chunk, random.nextLong(), mainChunkX, mainChunkZ, x, y, z, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, branchIndex, branchCount, 1.0, carvingMask, cachedBiomeProvider);
                this.carveTunnels(noiseProvider, chunk, random.nextLong(), mainChunkX, mainChunkZ, x, y, z, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, branchIndex, branchCount, 1.0, carvingMask, cachedBiomeProvider);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!this.canCarveBranch(mainChunkX, mainChunkZ, x, z, branchIndex, branchCount, width)) {
                return;
            }
            this.carveRegion(noiseProvider, null, chunk, seed, mainChunkX, mainChunkZ, x, y, z, currentYaw, currentPitch, carvingMask, cachedBiomeProvider);
        }
    }

    @Override
    protected boolean isPositionExcluded(float[] cache, double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return scaledRelativeY <= -0.7 || scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 1.0;
    }
}

