/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.carver;

import com.pg85.otg.gen.carver.Carver;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ISurfaceGeneratorNoiseProvider;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.BitSet;
import java.util.Random;

public class RavineCarver
extends Carver {
    public RavineCarver(int heightLimit, IWorldConfig worldConfig) {
        super(heightLimit, worldConfig);
    }

    @Override
    public boolean isStartChunk(Random random, int chunkX, int chunkZ) {
        return random.nextInt(100) < this.worldConfig.getRavineRarity();
    }

    @Override
    public boolean carve(ISurfaceGeneratorNoiseProvider noiseProvider, ChunkBuffer chunk, Random random, int chunkX, int chunkZ, int mainChunkX, int mainChunkZ, BitSet bitSet, ICachedBiomeProvider cachedBiomeProvider) {
        double x = chunkX * 16 + random.nextInt(16);
        double z = chunkZ * 16 + random.nextInt(16);
        double y = RandomHelper.numberInRange(random, this.worldConfig.getRavineMinAltitude(), this.worldConfig.getRavineMaxAltitude());
        float yaw = random.nextFloat() * ((float)Math.PI * 2);
        float pitch = (random.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float width = (random.nextFloat() * 2.0f + random.nextFloat()) * 2.0f;
        int branchCount = RandomHelper.numberInRange(random, this.worldConfig.getRavineMinLength(), this.worldConfig.getRavineMaxLength());
        branchCount -= random.nextInt(branchCount / 4);
        double yawPitchRatio = this.worldConfig.getRavineDepth();
        this.carveRavine(noiseProvider, chunk, random.nextLong(), mainChunkX, mainChunkZ, x, y, z, width, yaw, pitch, 0, branchCount, yawPitchRatio, bitSet, cachedBiomeProvider);
        return true;
    }

    private void carveRavine(ISurfaceGeneratorNoiseProvider noiseProvider, ChunkBuffer chunk, long seed, int mainChunkX, int mainChunkZ, double x, double y, double z, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, BitSet carvingMask, ICachedBiomeProvider cachedBiomeProvider) {
        Random random = new Random(seed);
        float stretchFactor = 1.0f;
        float[] heightToHorizontalStretchFactor = new float[1024];
        for (int y1 = 0; y1 < 256; ++y1) {
            if (y1 == 0 || random.nextInt(3) == 0) {
                stretchFactor = 1.0f + random.nextFloat() * random.nextFloat();
            }
            heightToHorizontalStretchFactor[y1] = stretchFactor * stretchFactor;
        }
        float yawChange = 0.0f;
        float pitchChange = 0.0f;
        for (int branchIndex = branchStartIndex; branchIndex < branchCount; ++branchIndex) {
            double currentYaw = 1.5 + (double)(MathHelper.sin((float)branchIndex * (float)Math.PI / (float)branchCount) * width);
            double currentPitch = currentYaw * yawPitchRatio;
            currentYaw *= (double)random.nextFloat() * 0.25 + 0.75;
            currentPitch *= (double)random.nextFloat() * 0.25 + 0.75;
            float deltaXZ = MathHelper.cos(pitch);
            float deltaY = MathHelper.sin(pitch);
            x += (double)(MathHelper.cos(yaw) * deltaXZ);
            y += (double)deltaY;
            z += (double)(MathHelper.sin(yaw) * deltaXZ);
            pitch *= 0.7f;
            pitch += pitchChange * 0.05f;
            yaw += yawChange * 0.05f;
            pitchChange *= 0.8f;
            yawChange *= 0.5f;
            pitchChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            yawChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) == 0) continue;
            if (!this.canCarveBranch(mainChunkX, mainChunkZ, x, z, branchIndex, branchCount, width)) {
                return;
            }
            this.carveRegion(noiseProvider, heightToHorizontalStretchFactor, chunk, seed, mainChunkX, mainChunkZ, x, y, z, currentYaw, currentPitch, carvingMask, cachedBiomeProvider);
        }
    }

    @Override
    protected boolean isPositionExcluded(float[] cache, double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return (scaledRelativeX * scaledRelativeX + scaledRelativeZ * scaledRelativeZ) * (double)cache[y - 1] + scaledRelativeY * scaledRelativeY / 6.0 >= 1.0;
    }
}

