/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.noise;

import com.google.common.collect.ImmutableList;
import com.pg85.otg.gen.noise.PerlinNoiseSampler;
import com.pg85.otg.util.Pair;
import com.pg85.otg.util.helpers.MathHelper;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public class OctavePerlinNoiseSampler {
    private final PerlinNoiseSampler[] octaves;
    private final DoubleList amplitudes;
    private final double persistence;
    private final double lacunarity;

    public OctavePerlinNoiseSampler(Random random, IntStream octaves) {
        this(random, (List)octaves.boxed().collect(ImmutableList.toImmutableList()));
    }

    private OctavePerlinNoiseSampler(Random random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    private OctavePerlinNoiseSampler(Random random, IntSortedSet octaves) {
        this(random, OctavePerlinNoiseSampler.generateAmplitudes(octaves));
    }

    private OctavePerlinNoiseSampler(Random random, Pair<Integer, DoubleList> octaves) {
        double amplitude;
        int octaveCount = octaves.getFirst();
        this.amplitudes = octaves.getSecond();
        PerlinNoiseSampler sampler = new PerlinNoiseSampler(random);
        int amplitudeLength = this.amplitudes.size();
        int totalOctaves = -octaveCount;
        this.octaves = new PerlinNoiseSampler[amplitudeLength];
        if (totalOctaves >= 0 && totalOctaves < amplitudeLength && (amplitude = this.amplitudes.getDouble(totalOctaves)) != 0.0) {
            this.octaves[totalOctaves] = sampler;
        }
        for (int i1 = totalOctaves - 1; i1 >= 0; --i1) {
            double amplitude2;
            if (i1 >= amplitudeLength || (amplitude2 = this.amplitudes.getDouble(i1)) == 0.0) continue;
            this.octaves[i1] = new PerlinNoiseSampler(random);
        }
        if (totalOctaves < amplitudeLength - 1) {
            long randomSeed = (long)(sampler.sample(0.0, 0.0, 0.0, 0.0, 0.0) * 9.223372036854776E18);
            Random rand = new Random(randomSeed);
            for (int l = totalOctaves + 1; l < amplitudeLength; ++l) {
                double amplitude3;
                if (l < 0 || (amplitude3 = this.amplitudes.getDouble(l)) == 0.0) continue;
                this.octaves[l] = new PerlinNoiseSampler(rand);
            }
        }
        this.lacunarity = Math.pow(2.0, -totalOctaves);
        this.persistence = Math.pow(2.0, amplitudeLength - 1) / (Math.pow(2.0, amplitudeLength) - 1.0);
    }

    public static OctavePerlinNoiseSampler create(Random random, int octaves, DoubleList amplitudes) {
        return new OctavePerlinNoiseSampler(random, Pair.of(octaves, amplitudes));
    }

    private static Pair<Integer, DoubleList> generateAmplitudes(IntSortedSet octaves) {
        int endOctave;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int startOctave = -octaves.firstInt();
        int totalOctaves = startOctave + (endOctave = octaves.lastInt()) + 1;
        if (totalOctaves < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList amplitudes = new DoubleArrayList(new double[totalOctaves]);
        IntBidirectionalIterator iterator = octaves.iterator();
        while (iterator.hasNext()) {
            int l = iterator.nextInt();
            amplitudes.set(l + startOctave, 1.0);
        }
        return Pair.of(-startOctave, amplitudes);
    }

    public static double maintainPrecision(double value) {
        return value - (double)MathHelper.lfloor(value / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    public double sample(double x, double y, double z) {
        return this.sample(x, y, z, 0.0, 0.0, false);
    }

    public double sample(double x, double y, double z, double yScale, double yOffset, boolean useOffset) {
        double sum = 0.0;
        double lacunarity = this.lacunarity;
        double persistence = this.persistence;
        for (int i = 0; i < this.octaves.length; ++i) {
            PerlinNoiseSampler sampler = this.octaves[i];
            if (sampler != null) {
                sum += this.amplitudes.getDouble(i) * sampler.sample(OctavePerlinNoiseSampler.maintainPrecision(x * lacunarity), useOffset ? -sampler.yOffset : OctavePerlinNoiseSampler.maintainPrecision(y * lacunarity), OctavePerlinNoiseSampler.maintainPrecision(z * lacunarity), yScale * lacunarity, yOffset * lacunarity) * persistence;
            }
            lacunarity *= 2.0;
            persistence /= 2.0;
        }
        return sum;
    }

    public PerlinNoiseSampler getOctave(int index) {
        return this.octaves[this.octaves.length - 1 - index];
    }

    public double sample(double x, double y, double yScale, double yOffset) {
        return this.sample(x, y, 0.0, yScale, yOffset, false);
    }
}

