/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.noise;

import com.google.common.collect.ImmutableList;
import com.pg85.otg.gen.noise.SimplexNoiseSampler;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public class OctaveSimplexNoiseSampler {
    private final SimplexNoiseSampler[] octaves;
    private final double persistence;
    private final double lacunarity;

    public OctaveSimplexNoiseSampler(Random random, IntStream octaves) {
        this(random, (List)octaves.boxed().collect(ImmutableList.toImmutableList()));
    }

    public OctaveSimplexNoiseSampler(Random random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    private OctaveSimplexNoiseSampler(Random random, IntSortedSet octaves) {
        int endOctave;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int startOctave = -octaves.firstInt();
        int totalOctaves = startOctave + (endOctave = octaves.lastInt()) + 1;
        if (totalOctaves < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        SimplexNoiseSampler sampler = new SimplexNoiseSampler(random);
        this.octaves = new SimplexNoiseSampler[totalOctaves];
        if (endOctave >= 0 && endOctave < totalOctaves && octaves.contains(0)) {
            this.octaves[endOctave] = sampler;
        }
        for (int i1 = endOctave + 1; i1 < totalOctaves; ++i1) {
            if (i1 < 0 || !octaves.contains(endOctave - i1)) continue;
            this.octaves[i1] = new SimplexNoiseSampler(random);
        }
        if (endOctave > 0) {
            long randomSeed = (long)(sampler.sample(sampler.xOffset, sampler.yOffset, sampler.zOffset) * 9.223372036854776E18);
            Random rand = new Random(randomSeed);
            for (int j1 = endOctave - 1; j1 >= 0; --j1) {
                if (j1 >= totalOctaves || !octaves.contains(endOctave - j1)) continue;
                this.octaves[j1] = new SimplexNoiseSampler(rand);
            }
        }
        this.lacunarity = Math.pow(2.0, endOctave);
        this.persistence = 1.0 / (Math.pow(2.0, totalOctaves) - 1.0);
    }

    public double sample(double x, double y, boolean useNoiseOffsets) {
        double sum = 0.0;
        double lacunarity = this.lacunarity;
        double persistence = this.persistence;
        for (SimplexNoiseSampler sampler : this.octaves) {
            if (sampler != null) {
                sum += sampler.sample(x * lacunarity + (useNoiseOffsets ? sampler.xOffset : 0.0), y * lacunarity + (useNoiseOffsets ? sampler.yOffset : 0.0)) * persistence;
            }
            lacunarity /= 2.0;
            persistence *= 2.0;
        }
        return sum;
    }

    public double sample(double x, double y, double yScale, double yOffset) {
        return this.sample(x, y, true) * 0.55;
    }
}

