/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.noise;

import com.pg85.otg.util.helpers.MathHelper;
import java.util.Random;

class SimplexNoiseSampler {
    protected static final int[][] GRAD = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {0, -1, 1}, {-1, 1, 0}, {0, -1, -1}};
    private static final double SQRT_3 = Math.sqrt(3.0);
    private static final double F2 = 0.5 * (SQRT_3 - 1.0);
    private static final double G2 = (3.0 - SQRT_3) / 6.0;
    final double xOffset;
    final double yOffset;
    final double zOffset;
    private final int[] permutations = new int[512];

    SimplexNoiseSampler(Random seed) {
        this.xOffset = seed.nextDouble() * 256.0;
        this.yOffset = seed.nextDouble() * 256.0;
        this.zOffset = seed.nextDouble() * 256.0;
        int i = 0;
        while (i < 256) {
            this.permutations[i] = i++;
        }
        for (int l = 0; l < 256; ++l) {
            int j = seed.nextInt(256 - l);
            int k = this.permutations[l];
            this.permutations[l] = this.permutations[j + l];
            this.permutations[j + l] = k;
        }
    }

    protected static double dot(int[] gradElement, double xFactor, double yFactor, double zFactor) {
        return (double)gradElement[0] * xFactor + (double)gradElement[1] * yFactor + (double)gradElement[2] * zFactor;
    }

    private int getPermutValue(int permutIndex) {
        return this.permutations[permutIndex & 0xFF];
    }

    private double grad(int gradIndex, double x, double y, double z, double offset) {
        double d0;
        double d1 = offset - x * x - y * y - z * z;
        if (d1 < 0.0) {
            d0 = 0.0;
        } else {
            d1 *= d1;
            d0 = d1 * d1 * SimplexNoiseSampler.dot(GRAD[gradIndex], x, y, z);
        }
        return d0;
    }

    public double sample(double x, double y) {
        int l;
        int k;
        double d3;
        double d5;
        int j;
        double d1;
        double d0 = (x + y) * F2;
        int i = MathHelper.floor(x + d0);
        double d2 = (double)i - (d1 = (double)(i + (j = MathHelper.floor(y + d0))) * G2);
        double d4 = x - d2;
        if (d4 > (d5 = y - (d3 = (double)j - d1))) {
            k = 1;
            l = 0;
        } else {
            k = 0;
            l = 1;
        }
        double d6 = d4 - (double)k + G2;
        double d7 = d5 - (double)l + G2;
        double d8 = d4 - 1.0 + 2.0 * G2;
        double d9 = d5 - 1.0 + 2.0 * G2;
        int i1 = i & 0xFF;
        int j1 = j & 0xFF;
        int k1 = this.getPermutValue(i1 + this.getPermutValue(j1)) % 12;
        int l1 = this.getPermutValue(i1 + k + this.getPermutValue(j1 + l)) % 12;
        int i2 = this.getPermutValue(i1 + 1 + this.getPermutValue(j1 + 1)) % 12;
        double d10 = this.grad(k1, d4, d5, 0.0, 0.5);
        double d11 = this.grad(l1, d6, d7, 0.0, 0.5);
        double d12 = this.grad(i2, d8, d9, 0.0, 0.5);
        return 70.0 * (d10 + d11 + d12);
    }

    public double sample(double x, double y, double z) {
        int i2;
        int l1;
        int k1;
        int j1;
        int i1;
        int l;
        double d1 = (x + y + z) * 0.3333333333333333;
        int i = MathHelper.floor(x + d1);
        int j = MathHelper.floor(y + d1);
        int k = MathHelper.floor(z + d1);
        double d3 = (double)(i + j + k) * 0.16666666666666666;
        double d4 = (double)i - d3;
        double d5 = (double)j - d3;
        double d6 = (double)k - d3;
        double d7 = x - d4;
        double d8 = y - d5;
        double d9 = z - d6;
        if (d7 >= d8) {
            if (d8 >= d9) {
                l = 1;
                i1 = 0;
                j1 = 0;
                k1 = 1;
                l1 = 1;
                i2 = 0;
            } else if (d7 >= d9) {
                l = 1;
                i1 = 0;
                j1 = 0;
                k1 = 1;
                l1 = 0;
                i2 = 1;
            } else {
                l = 0;
                i1 = 0;
                j1 = 1;
                k1 = 1;
                l1 = 0;
                i2 = 1;
            }
        } else if (d8 < d9) {
            l = 0;
            i1 = 0;
            j1 = 1;
            k1 = 0;
            l1 = 1;
            i2 = 1;
        } else if (d7 < d9) {
            l = 0;
            i1 = 1;
            j1 = 0;
            k1 = 0;
            l1 = 1;
            i2 = 1;
        } else {
            l = 0;
            i1 = 1;
            j1 = 0;
            k1 = 1;
            l1 = 1;
            i2 = 0;
        }
        double d10 = d7 - (double)l + 0.16666666666666666;
        double d11 = d8 - (double)i1 + 0.16666666666666666;
        double d12 = d9 - (double)j1 + 0.16666666666666666;
        double d13 = d7 - (double)k1 + 0.3333333333333333;
        double d14 = d8 - (double)l1 + 0.3333333333333333;
        double d15 = d9 - (double)i2 + 0.3333333333333333;
        double d16 = d7 - 1.0 + 0.5;
        double d17 = d8 - 1.0 + 0.5;
        double d18 = d9 - 1.0 + 0.5;
        int j2 = i & 0xFF;
        int k2 = j & 0xFF;
        int l2 = k & 0xFF;
        int i3 = this.getPermutValue(j2 + this.getPermutValue(k2 + this.getPermutValue(l2))) % 12;
        int j3 = this.getPermutValue(j2 + l + this.getPermutValue(k2 + i1 + this.getPermutValue(l2 + j1))) % 12;
        int k3 = this.getPermutValue(j2 + k1 + this.getPermutValue(k2 + l1 + this.getPermutValue(l2 + i2))) % 12;
        int l3 = this.getPermutValue(j2 + 1 + this.getPermutValue(k2 + 1 + this.getPermutValue(l2 + 1))) % 12;
        double d19 = this.grad(i3, d7, d8, d9, 0.6);
        double d20 = this.grad(j3, d10, d11, d12, 0.6);
        double d21 = this.grad(k3, d13, d14, d15, 0.6);
        double d22 = this.grad(l3, d16, d17, d18, 0.6);
        return 32.0 * (d19 + d20 + d21 + d22);
    }
}

