/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.List;
import java.util.Random;

public class AboveWaterResource
extends FrequencyResourceBase {
    private final LocalMaterialData material;

    public AboveWaterResource(IBiomeConfig config, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(config, args, logger, materialReader);
        this.assureSize(3, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
    }

    @Override
    public void spawn(IWorldGenRegion worldGenregion, Random rand, int x, int z) {
        int y = worldGenregion.getBlockAboveLiquidHeight(x, z);
        if (y == -1) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            LocalMaterialData worldMaterialBeneath;
            int localZ;
            int localY;
            int localX = x + rand.nextInt(8) - rand.nextInt(8);
            LocalMaterialData worldMaterial = worldGenregion.getMaterial(localX, localY = y + rand.nextInt(4) - rand.nextInt(4), localZ = z + rand.nextInt(8) - rand.nextInt(8));
            if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterialBeneath = worldGenregion.getMaterial(localX, localY - 1, localZ)) != null && !worldMaterialBeneath.isLiquid()) continue;
            worldGenregion.setBlock(localX, localY, localZ, this.material);
        }
    }

    @Override
    public String toString() {
        return "AboveWaterRes(" + this.material + "," + this.frequency + "," + this.rarity + ")";
    }
}

