/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class BambooResource
extends FrequencyResourceBase {
    private final double podzolChance;
    private final MaterialSet sourceBlocks;

    public BambooResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.frequency = this.readInt(args.get(0), 1, 500);
        this.rarity = this.readRarity(args.get(1));
        this.podzolChance = this.readDouble(args.get(2), 0.0, 1.0);
        this.sourceBlocks = this.readMaterials(args, 3, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        int y = world.getHighestBlockAboveYAt(x, z);
        int height = random.nextInt(12) + 5;
        if (world.getMaterial(x, y, z).isAir()) {
            LocalMaterialData below = world.getMaterial(x, y - 1, z);
            if (below == null || !this.sourceBlocks.contains(below)) {
                return;
            }
            for (int y1 = 0; y1 < height; ++y1) {
                if (world.getMaterial(x, y + y1, z).isAir()) continue;
                height = y1;
                break;
            }
            if (random.nextDouble() <= this.podzolChance) {
                int radius = random.nextInt(4) + 1;
                for (int x1 = -radius; x1 <= radius; ++x1) {
                    for (int z1 = -radius; z1 <= radius; ++z1) {
                        int topY;
                        if (x1 * x1 + z1 * z1 > radius * radius || !this.sourceBlocks.contains(world.getMaterial(x + x1, (topY = world.getHighestBlockAboveYAt(x + x1, z + z1)) - 1, z + z1))) continue;
                        world.setBlock(x + x1, topY - 1, z + z1, LocalMaterials.PODZOL);
                    }
                }
            }
            for (int y1 = 0; y1 < height; ++y1) {
                LocalMaterialData bamboo = LocalMaterials.BAMBOO;
                if (y1 == height - 1) {
                    bamboo = LocalMaterials.BAMBOO_LARGE_GROWING;
                } else if (y1 == height - 2) {
                    bamboo = LocalMaterials.BAMBOO_LARGE;
                } else if (y1 == height - 3) {
                    bamboo = LocalMaterials.BAMBOO_SMALL;
                }
                world.setBlock(x, y + y1, z, bamboo);
            }
        }
    }

    @Override
    public String toString() {
        return "Bamboo(" + this.frequency + "," + this.rarity + "," + this.podzolChance + "," + this.sourceBlocks + ")";
    }
}

