/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class BoulderResource
extends FrequencyResourceBase {
    private final MaterialSet sourceBlocks;
    private final LocalMaterialData material;
    private final int minAltitude;
    private final int maxAltitude;

    public BoulderResource(IBiomeConfig config, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(config, args, logger, materialReader);
        this.assureSize(6, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 5000);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 255);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 5, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random random, int x, int z) {
        LocalMaterialData material;
        int y = worldGenRegion.getHighestBlockAboveYAt(x, z);
        if (y < this.minAltitude || y > this.maxAltitude) {
            return;
        }
        while (y > 3 && !this.sourceBlocks.contains(material = worldGenRegion.getMaterial(x, y - 1, z))) {
            --y;
        }
        if (y <= 3) {
            return;
        }
        int i = 0;
        for (int j = 0; i >= 0 && j < 3; ++j) {
            int k = i + random.nextInt(2);
            int m = i + random.nextInt(2);
            int n = i + random.nextInt(2);
            float f1 = (float)(k + m + n) * 0.333f + 0.5f;
            for (int i1 = x - k; i1 <= x + k; ++i1) {
                for (int i2 = z - n; i2 <= z + n; ++i2) {
                    IBiomeConfig biome = worldGenRegion.getBiomeConfigForDecoration(i1, i2);
                    for (int i3 = y - m; i3 <= y + m; ++i3) {
                        float f2 = i1 - x;
                        float f3 = i2 - z;
                        float f4 = i3 - y;
                        if (!(f2 * f2 + f3 * f3 + f4 * f4 <= f1 * f1)) continue;
                        worldGenRegion.setBlock(i1, i3, i2, this.material, biome.getReplaceBlocks());
                    }
                }
            }
            x += random.nextInt(2 + i * 2) - 1 - i;
            z += random.nextInt(2 + i * 2) - 1 - i;
            y -= random.nextInt(2);
        }
    }

    @Override
    public String toString() {
        return "Boulder(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }
}

