/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class CactusResource
extends FrequencyResourceBase {
    private final LocalMaterialData material;
    private final int minAltitude;
    private final int maxAltitude;
    private final MaterialSet sourceBlocks;

    public CactusResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(6, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 255);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 5, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion worldGenregion, Random rand, int x, int z) {
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        for (int i = 0; i < 10; ++i) {
            int cactusZ;
            int cactusBaseY;
            int cactusX = x + rand.nextInt(8) - rand.nextInt(8);
            LocalMaterialData worldMaterial = worldGenregion.getMaterial(cactusX, cactusBaseY = y + rand.nextInt(4) - rand.nextInt(4), cactusZ = z + rand.nextInt(8) - rand.nextInt(8));
            if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(cactusX, cactusBaseY - 1, cactusZ)) == null || !this.sourceBlocks.contains(worldMaterial) || (worldMaterial = worldGenregion.getMaterial(cactusX - 1, cactusBaseY, cactusZ)) == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(cactusX + 1, cactusBaseY, cactusZ)) == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(cactusX, cactusBaseY, cactusZ - 1)) == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(cactusX, cactusBaseY, cactusZ + 1)) == null || !worldMaterial.isAir()) continue;
            int cactusHeight = 1 + rand.nextInt(rand.nextInt(3) + 1);
            for (int dY = 0; dY < cactusHeight; ++dY) {
                worldGenregion.setBlock(cactusX, cactusBaseY + dY, cactusZ, this.material);
            }
        }
    }

    @Override
    public String toString() {
        return "Cactus(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }
}

