/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.google.common.collect.Lists;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.gen.resource.util.CoralHelper;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.OTGDirection;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class CoralClawResource
extends FrequencyResourceBase {
    private static final OTGDirection[] HORIZONTAL = new OTGDirection[]{OTGDirection.NORTH, OTGDirection.EAST, OTGDirection.SOUTH, OTGDirection.WEST};

    private static OTGDirection randomDirection(OTGDirection[] array, Random random) {
        return array[random.nextInt(array.length)];
    }

    private static OTGDirection randomDirection(Random random) {
        return HORIZONTAL[random.nextInt(3)];
    }

    public CoralClawResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.frequency = this.readInt(args.get(0), 1, 500);
        this.rarity = this.readRarity(args.get(1));
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        int y = world.getBlockAboveSolidHeight(x, z);
        LocalMaterialData coral = CoralHelper.getRandomCoralBlock(random);
        if (y < 0 || y > 255 || !CoralHelper.placeCoralBlock(world, random, x, y, z, coral)) {
            return;
        }
        OTGDirection initial = CoralClawResource.randomDirection(random);
        ArrayList list = Lists.newArrayList((Object[])new OTGDirection[]{initial, initial.getClockWise(), initial.getCounterClockWise()});
        Collections.shuffle(list, random);
        int dirEnd = random.nextInt(2) + 2;
        for (OTGDirection direction : list.subList(0, dirEnd)) {
            int i;
            int clawLength;
            OTGDirection finalDir;
            int dx = x + direction.getX();
            int dy = y;
            int dz = z + direction.getZ();
            int branchLength = random.nextInt(2) + 1;
            if (direction == initial) {
                finalDir = direction;
                clawLength = random.nextInt(3) + 2;
            } else {
                ++dy;
                finalDir = CoralClawResource.randomDirection(new OTGDirection[]{direction, OTGDirection.UP}, random);
                clawLength = random.nextInt(3) + 3;
            }
            for (i = 0; i < branchLength && dy >= 0 && dy <= 255 && CoralHelper.placeCoralBlock(world, random, dx, dy, dz, coral); ++i) {
                dx += finalDir.getX();
                dy += finalDir.getY();
                dz += finalDir.getZ();
            }
            dx -= finalDir.getX();
            dy -= finalDir.getY();
            dz -= finalDir.getZ();
            ++dy;
            for (i = 0; i < clawLength && (dy += initial.getY()) >= 0 && dy <= 255 && CoralHelper.placeCoralBlock(world, random, dx += initial.getX(), dy, dz += initial.getZ(), coral); ++i) {
                if (!((double)random.nextFloat() < 0.25)) continue;
                ++dy;
            }
        }
    }

    @Override
    public String toString() {
        return "CoralClaw(" + this.frequency + "," + this.rarity + ")";
    }
}

