/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.gen.resource.util.CoralHelper;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.OTGDirection;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class CoralTreeResource
extends FrequencyResourceBase {
    private static final OTGDirection[] HORIZONTAL = new OTGDirection[]{OTGDirection.NORTH, OTGDirection.EAST, OTGDirection.SOUTH, OTGDirection.WEST};

    public CoralTreeResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.frequency = this.readInt(args.get(0), 1, 500);
        this.rarity = this.readRarity(args.get(1));
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        int y = world.getBlockAboveSolidHeight(x, z);
        LocalMaterialData coral = CoralHelper.getRandomCoralBlock(random);
        int height = random.nextInt(3) + 1;
        for (int i = 0; i < height; ++i) {
            if (y + i >= 0 && y + i <= 255 && CoralHelper.placeCoralBlock(world, random, x, y + i, z, coral)) continue;
            return;
        }
        y += height;
        int dirEnd = random.nextInt(3) + 2;
        List<OTGDirection> directions = Arrays.asList(HORIZONTAL);
        Collections.shuffle(directions, random);
        for (OTGDirection direction : directions.subList(0, dirEnd)) {
            int dx = x + direction.getX();
            int dy = y;
            int dz = z + direction.getZ();
            int count = random.nextInt(5) + 2;
            int placedIndex = 0;
            for (int i = 0; i < count && dy >= 0 && dy <= 255 && CoralHelper.placeCoralBlock(world, random, dx, dy, dz, coral); ++i) {
                ++dy;
                if (i != 0 && (++placedIndex < 2 || !(random.nextFloat() < 0.25f))) continue;
                dx += direction.getX();
                dz += direction.getZ();
                placedIndex = 0;
            }
        }
    }

    @Override
    public String toString() {
        return "CoralTree(" + this.frequency + "," + this.rarity + ")";
    }
}

