/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.List;
import java.util.Random;

public class DungeonResource
extends FrequencyResourceBase {
    private final int maxAltitude;
    private final int minAltitude;

    public DungeonResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(3, args);
        this.frequency = 1;
        this.rarity = this.readDouble(args.get(0), 1.0, 2.147483647E9);
        this.minAltitude = this.readInt(args.get(1), 0, 255);
        this.maxAltitude = this.readInt(args.get(2), this.minAltitude, 255);
    }

    @Override
    public String toString() {
        return "Dungeon(" + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        int y = RandomHelper.numberInRange(random, this.minAltitude, this.maxAltitude);
        world.placeDungeon(random, world.getDecorationArea().getChunkBeingDecoratedCenterX(), y, world.getDecorationArea().getChunkBeingDecoratedCenterZ());
    }
}

