/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import java.util.List;
import java.util.Random;

public abstract class FrequencyResourceBase
extends BiomeResourceBase
implements IBasicResource {
    protected int frequency;
    protected double rarity;

    public FrequencyResourceBase(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) {
        super(biomeConfig, args, logger, materialReader);
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion worldGenRegion, Random random, ILogger logger, IMaterialReader materialReader) {
        int blockX = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterX();
        int blockZ = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterZ();
        for (int t = 0; t < this.frequency; ++t) {
            if (random.nextDouble() * 100.0 > this.rarity) continue;
            int x = blockX + random.nextInt(16);
            int z = blockZ + random.nextInt(16);
            this.spawn(worldGenRegion, random, x, z);
        }
    }

    public abstract void spawn(IWorldGenRegion var1, Random var2, int var3, int var4);
}

