/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import com.pg85.otg.util.minecraft.PlantType;
import java.util.List;
import java.util.Random;

public class GrassResource
extends BiomeResourceBase
implements IBasicResource {
    private final int frequency;
    private final double rarity;
    private GroupOption groupOption;
    private PlantType plant;
    private final MaterialSet sourceBlocks;

    public GrassResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        block2: {
            super(biomeConfig, args, logger, materialReader);
            this.assureSize(5, args);
            this.groupOption = GroupOption.NotGrouped;
            String secondArgument = args.get(1);
            try {
                this.readInt(secondArgument, 0, 16);
                this.plant = PlantType.getPlant(args.get(0) + ":" + secondArgument, materialReader);
            }
            catch (InvalidConfigException e) {
                this.plant = PlantType.getPlant(args.get(0), materialReader);
                if (!secondArgument.equalsIgnoreCase(GroupOption.Grouped.toString())) break block2;
                this.groupOption = GroupOption.Grouped;
            }
        }
        this.frequency = this.readInt(args.get(2), 1, 500);
        this.rarity = this.readRarity(args.get(3));
        this.sourceBlocks = this.readMaterials(args, 4, materialReader);
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion worldGenRegion, Random random, ILogger logger, IMaterialReader materialReader) {
        switch (this.groupOption) {
            case Grouped: {
                this.spawnGrouped(worldGenRegion, random);
                break;
            }
            case NotGrouped: {
                this.spawnNotGrouped(worldGenRegion, random);
            }
        }
    }

    private void spawnGrouped(IWorldGenRegion worldGenregion, Random random) {
        if (random.nextDouble() * 100.0 <= this.rarity) {
            LocalMaterialData worldMaterial;
            int centerZ;
            int centerX = worldGenregion.getDecorationArea().getChunkBeingDecoratedCenterX() + random.nextInt(16);
            int centerY = worldGenregion.getHighestBlockAboveYAt(centerX, centerZ = worldGenregion.getDecorationArea().getChunkBeingDecoratedCenterZ() + random.nextInt(16));
            if (centerY < 0) {
                return;
            }
            while (centerY >= 0 && centerY < 256 && (worldMaterial = worldGenregion.getMaterial(centerX, centerY, centerZ)) != null && (worldMaterial.isAir() || worldMaterial.isLeaves()) && (worldMaterial = worldGenregion.getMaterial(centerX, centerY - 1, centerZ)) != null && centerY > 0) {
                --centerY;
            }
            ++centerY;
            for (int i = 0; i < this.frequency * 4; ++i) {
                int z;
                int y;
                int x = centerX + random.nextInt(8) - random.nextInt(8);
                worldMaterial = worldGenregion.getMaterial(x, y = centerY + random.nextInt(4) - random.nextInt(4), z = centerZ + random.nextInt(8) - random.nextInt(8));
                if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(x, y - 1, z)) == null || !this.sourceBlocks.contains(worldMaterial)) continue;
                this.plant.spawn(worldGenregion, x, y, z);
            }
        }
    }

    private void spawnNotGrouped(IWorldGenRegion worldGenregion, Random random) {
        for (int t = 0; t < this.frequency; ++t) {
            LocalMaterialData worldMaterial;
            int z;
            if ((double)random.nextInt(100) >= this.rarity) continue;
            int x = worldGenregion.getDecorationArea().getChunkBeingDecoratedCenterX() + random.nextInt(16);
            int y = worldGenregion.getHighestBlockAboveYAt(x, z = worldGenregion.getDecorationArea().getChunkBeingDecoratedCenterZ() + random.nextInt(16));
            if (y < 0) {
                return;
            }
            while ((worldMaterial = worldGenregion.getMaterial(x, y, z)) != null && (worldMaterial.isAir() || worldMaterial.isLeaves()) && (worldMaterial = worldGenregion.getMaterial(x, y - 1, z)) != null && y > 0) {
                --y;
            }
            worldMaterial = worldGenregion.getMaterial(x, y + 1, z);
            if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(x, y, z)) == null || !this.sourceBlocks.contains(worldMaterial)) continue;
            this.plant.spawn(worldGenregion, x, y + 1, z);
        }
    }

    @Override
    public String toString() {
        return "Grass(" + this.plant.getName() + "," + (Object)((Object)this.groupOption) + "," + this.frequency + "," + this.rarity + this.makeMaterials(this.sourceBlocks) + ")";
    }

    private static enum GroupOption {
        Grouped,
        NotGrouped;

    }
}

