/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class IceSpikeResource
extends FrequencyResourceBase {
    private final LocalMaterialData material;
    private final int maxAltitude;
    private final int minAltitude;
    private final MaterialSet sourceBlocks;
    private SettingsEnums.IceSpikeType type;

    public IceSpikeResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(2, args);
        this.material = materialReader.readMaterial(args.get(0));
        String typeString = args.get(1);
        this.type = null;
        for (SettingsEnums.IceSpikeType possibleType : SettingsEnums.IceSpikeType.values()) {
            if (!possibleType.toString().equalsIgnoreCase(typeString)) continue;
            this.type = possibleType;
            break;
        }
        if (this.type == null) {
            throw new InvalidConfigException("Unknown spike type " + typeString);
        }
        this.frequency = this.readInt(args.get(2), 1, 30);
        this.rarity = this.readRarity(args.get(3));
        this.minAltitude = this.readInt(args.get(4), 0, 255);
        this.maxAltitude = this.readInt(args.get(5), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 6, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion worldGenregion, Random random, int x, int z) {
        switch (this.type) {
            case Basement: {
                this.spawnBasement(worldGenregion, random, x, z);
                break;
            }
            case HugeSpike: {
                this.spawnSpike(worldGenregion, random, x, z, true);
                break;
            }
            case SmallSpike: {
                this.spawnSpike(worldGenregion, random, x, z, false);
            }
        }
    }

    private void spawnBasement(IWorldGenRegion worldGenRegion, Random random, int x, int z) {
        LocalMaterialData worldMaterial;
        int y;
        for (y = RandomHelper.numberInRange(random, this.minAltitude, this.maxAltitude); y > 2 && (worldMaterial = worldGenRegion.getMaterial(x, y, z)) != null && worldMaterial.isAir(); --y) {
        }
        worldMaterial = worldGenRegion.getMaterial(x, y, z);
        if (worldMaterial == null || !this.sourceBlocks.contains(worldMaterial)) {
            return;
        }
        int radius = random.nextInt(2) + 2;
        int one = 1;
        for (int actualX = x - radius; actualX <= x + radius; ++actualX) {
            for (int actualZ = z - radius; actualZ <= z + radius; ++actualZ) {
                IBiomeConfig biomeConfig = worldGenRegion.getBiomeConfigForDecoration(actualX, actualZ);
                int deltaX = actualX - x;
                int deltaZ = actualZ - z;
                if (deltaX * deltaX + deltaZ * deltaZ > radius * radius) continue;
                for (int deltaY = y - one; deltaY <= y + one; ++deltaY) {
                    worldMaterial = worldGenRegion.getMaterial(actualX, deltaY, actualZ);
                    if (worldMaterial == null || !this.sourceBlocks.contains(worldMaterial)) continue;
                    worldGenRegion.setBlock(actualX, deltaY, actualZ, this.material, biomeConfig.getReplaceBlocks());
                }
            }
        }
    }

    private void spawnSpike(IWorldGenRegion worldGenRegion, Random random, int x, int z, boolean hugeSpike) {
        int var11;
        int var10;
        int var8;
        LocalMaterialData worldMaterial;
        int y;
        for (y = RandomHelper.numberInRange(random, this.minAltitude, this.maxAltitude); y > 2 && (worldMaterial = worldGenRegion.getMaterial(x, y, z)) != null && worldMaterial.isAir(); --y) {
        }
        worldMaterial = worldGenRegion.getMaterial(x, y, z);
        if (worldMaterial == null || !this.sourceBlocks.contains(worldMaterial)) {
            return;
        }
        y += random.nextInt(4);
        int var6 = random.nextInt(4) + 7;
        int var7 = var6 / 4 + random.nextInt(2);
        if (var7 > 1 && hugeSpike) {
            y += 10 + random.nextInt(30);
        }
        for (var8 = 0; var8 < var6; ++var8) {
            float var9 = (1.0f - (float)var8 / (float)var6) * (float)var7;
            var10 = MathHelper.ceil(var9);
            for (var11 = -var10; var11 <= var10; ++var11) {
                float var12 = (float)MathHelper.abs(var11) - 0.25f;
                for (int var13 = -var10; var13 <= var10; ++var13) {
                    float var14 = (float)MathHelper.abs(var13) - 0.25f;
                    IBiomeConfig biomeConfig = worldGenRegion.getBiomeConfigForDecoration(x + var11, z + var13);
                    if ((var11 != 0 || var13 != 0) && !(var12 * var12 + var14 * var14 <= var9 * var9) || (var11 == -var10 || var11 == var10 || var13 == -var10 || var13 == var10) && !(random.nextFloat() <= 0.75f)) continue;
                    worldMaterial = worldGenRegion.getMaterial(x + var11, y + var8, z + var13);
                    if (worldMaterial != null && (worldMaterial.isAir() || this.sourceBlocks.contains(worldMaterial))) {
                        worldGenRegion.setBlock(x + var11, y + var8, z + var13, this.material, biomeConfig.getReplaceBlocks());
                    }
                    if (var8 == 0 || var10 <= 1 || (worldMaterial = worldGenRegion.getMaterial(x + var11, y - var8, z + var13)) == null || !worldMaterial.isAir() && !this.sourceBlocks.contains(worldMaterial)) continue;
                    worldGenRegion.setBlock(x + var11, y - var8, z + var13, this.material, biomeConfig.getReplaceBlocks());
                }
            }
        }
        var8 = var7 - 1;
        if (var8 < 0) {
            var8 = 0;
        } else if (var8 > 1) {
            var8 = 1;
        }
        for (int var16 = -var8; var16 <= var8; ++var16) {
            for (var10 = -var8; var10 <= var8; ++var10) {
                var11 = y - 1;
                int var17 = 50;
                if (Math.abs(var16) == 1 && Math.abs(var10) == 1) {
                    var17 = random.nextInt(5);
                }
                while (var11 > 50 && (worldMaterial = worldGenRegion.getMaterial(x + var16, var11, z + var10)) != null && (worldMaterial.isAir() || this.sourceBlocks.contains(worldMaterial) || worldMaterial.equals(this.material))) {
                    worldGenRegion.setBlock(x + var16, var11, z + var10, this.material, worldGenRegion.getBiomeConfigForDecoration(x + var16, z + var10).getReplaceBlocks());
                    --var11;
                    if (--var17 > 0) continue;
                    var11 -= random.nextInt(5) + 1;
                    var17 = random.nextInt(5);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "IceSpike(" + this.material + "," + (Object)((Object)this.type) + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }
}

