/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.List;
import java.util.Random;

public class IcebergResource
extends BiomeResourceBase
implements IBasicResource {
    private final LocalMaterialData[] materials;
    private final LocalMaterialData[] materials2;
    private final double[] rarities;
    private final double totalRarity;

    public IcebergResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(4, args);
        int size = (int)Math.floor(args.size() / 3);
        this.materials = new LocalMaterialData[size];
        this.materials2 = new LocalMaterialData[size];
        this.rarities = new double[size];
        int pos = 0;
        for (int i = 0; i < args.size() - 1; i += 3) {
            this.materials[pos] = materialReader.readMaterial(args.get(i));
            this.materials2[pos] = materialReader.readMaterial(args.get(i + 1));
            this.rarities[pos] = this.readRarity(args.get(i + 2));
            ++pos;
        }
        this.totalRarity = StringHelper.readDouble(args.get(args.size() - 1), 1.0E-6, 2.147483647E9);
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion world, Random random, ILogger logger, IMaterialReader materialReader) {
        boolean flag3;
        int y1;
        int z1;
        int x1;
        int ismoothheight;
        LocalMaterialData material = null;
        LocalMaterialData material2 = null;
        double currentRarity = 0.0;
        int rarity = random.nextInt((int)this.totalRarity);
        for (int i = 0; i < this.rarities.length; ++i) {
            if (!((currentRarity += this.rarities[i]) >= (double)rarity)) continue;
            material = this.materials[i];
            material2 = this.materials2[i];
            break;
        }
        if (material == null) {
            return;
        }
        int x = world.getDecorationArea().getChunkBeingDecorated().getBlockX();
        int z = world.getDecorationArea().getChunkBeingDecorated().getBlockZ();
        int y = world.getBiomeConfigForDecoration(x, z).getWaterLevelMax();
        boolean flag1 = random.nextDouble() > 0.7;
        double drandom1 = random.nextDouble() * 2.0 * Math.PI;
        int irandom1 = 11 - random.nextInt(5);
        int irandom2 = 3 + random.nextInt(3);
        boolean flag2 = random.nextDouble() > 0.7;
        int n = ismoothheight = flag2 ? random.nextInt(6) + 6 : random.nextInt(15) + 3;
        if (!flag2 && random.nextDouble() > 0.9) {
            ismoothheight += random.nextInt(19) + 7;
        }
        int irandom4 = Math.min(ismoothheight + random.nextInt(11), 18);
        int irandom5 = Math.min(ismoothheight + random.nextInt(7) - random.nextInt(5), 11);
        int irandom6 = flag2 ? irandom1 : 11;
        for (x1 = -irandom6; x1 < irandom6; ++x1) {
            for (z1 = -irandom6; z1 < irandom6; ++z1) {
                for (y1 = 0; y1 < ismoothheight; ++y1) {
                    int heightDependentRadiusEllipse;
                    int n2 = heightDependentRadiusEllipse = flag2 ? this.heightDependentRadiusEllipse(y1, ismoothheight, irandom5) : this.heightDependentRadiusRound(random, y1, ismoothheight, irandom5);
                    if (!flag2 && x1 >= heightDependentRadiusEllipse) continue;
                    this.generateIcebergBlock(world, random, x, y, z, ismoothheight, x1, y1, z1, heightDependentRadiusEllipse, irandom6, flag2, irandom2, drandom1, flag1, material, material2);
                }
            }
        }
        this.smooth(world, x, y, z, irandom5, ismoothheight, flag2, irandom1, material, material2);
        for (x1 = -irandom6; x1 < irandom6; ++x1) {
            for (z1 = -irandom6; z1 < irandom6; ++z1) {
                for (y1 = -1; y1 > -irandom4; --y1) {
                    int irandom7 = flag2 ? MathHelper.ceil((float)irandom6 * (1.0f - (float)Math.pow(y1, 2.0) / ((float)irandom4 * 8.0f))) : irandom6;
                    int heightDependentRadiusSteep = this.heightDependentRadiusSteep(random, -y1, irandom4, irandom5);
                    if (x1 >= heightDependentRadiusSteep) continue;
                    this.generateIcebergBlock(world, random, x, y, z, irandom4, x1, y1, z1, heightDependentRadiusSteep, irandom7, flag2, irandom2, drandom1, flag1, material, material2);
                }
            }
        }
        boolean bl = flag2 ? random.nextDouble() > 0.1 : (flag3 = random.nextDouble() > 0.7);
        if (flag3) {
            this.generateCutOut(random, world, irandom5, ismoothheight, x, y, z, flag2, irandom1, drandom1, irandom2, material, material2);
        }
    }

    private void generateCutOut(Random random, IWorldGenRegion world, int irandom, int irandom1, int x, int y, int z, boolean flag, int irandom2, double drandom1, int irandom3, LocalMaterialData material, LocalMaterialData material2) {
        int irandom8;
        int irandom4 = random.nextBoolean() ? -1 : 1;
        int irandom5 = random.nextBoolean() ? -1 : 1;
        int irandom6 = random.nextInt(Math.max(irandom / 2 - 2, 1));
        if (random.nextBoolean()) {
            irandom6 = irandom / 2 + 1 - random.nextInt(Math.max(irandom - irandom / 2 - 1, 1));
        }
        int irandom7 = random.nextInt(Math.max(irandom / 2 - 2, 1));
        if (random.nextBoolean()) {
            irandom7 = irandom / 2 + 1 - random.nextInt(Math.max(irandom - irandom / 2 - 1, 1));
        }
        if (flag) {
            irandom6 = irandom7 = random.nextInt(Math.max(irandom2 - 5, 1));
        }
        int x2 = irandom4 * irandom6;
        int z2 = irandom5 * irandom7;
        double drandom2 = flag ? drandom1 + 1.5707963267948966 : random.nextDouble() * 2.0 * Math.PI;
        for (irandom8 = 0; irandom8 < irandom1 - 3; ++irandom8) {
            int heightDependentRadiusRound = this.heightDependentRadiusRound(random, irandom8, irandom1, irandom);
            this.carve(heightDependentRadiusRound, irandom8, x, y, z, world, false, drandom2, x2, z2, irandom2, irandom3, material, material2);
        }
        for (irandom8 = -1; irandom8 > -irandom1 + random.nextInt(5); --irandom8) {
            int heightDependentRadiusSteep = this.heightDependentRadiusSteep(random, -irandom8, irandom1, irandom);
            this.carve(heightDependentRadiusSteep, irandom8, x, y, z, world, true, drandom2, x2, z2, irandom2, irandom3, material, material2);
        }
    }

    private void carve(int heightDependentRadius, int irandom, int x, int y, int z, IWorldGenRegion world, boolean flag, double drandom, int x3, int z3, int irandom1, int irandom2, LocalMaterialData material, LocalMaterialData material2) {
        int irandom3 = heightDependentRadius + 1 + irandom1 / 3;
        int irandom4 = Math.min(heightDependentRadius - 3, 3) + irandom2 / 2 - 1;
        for (int x1 = -irandom3; x1 < irandom3; ++x1) {
            for (int z1 = -irandom3; z1 < irandom3; ++z1) {
                double signedDistanceEllipse = this.signedDistanceEllipse(x1, z1, x3, 0, z3, irandom3, irandom4, drandom);
                if (!(signedDistanceEllipse < 0.0)) continue;
                int x2 = x + x1;
                int y2 = y + irandom;
                int z2 = z + z1;
                LocalMaterialData current = world.getMaterialDirect(x2, y2, z2);
                IBiomeConfig biomeConfig = world.getCachedBiomeProvider().getBiomeConfig(x2, z2, true);
                LocalMaterialData replacedMaterial = material;
                LocalMaterialData replacedMaterial2 = material2;
                if (biomeConfig.getReplaceBlocks() != null) {
                    replacedMaterial = biomeConfig.getReplaceBlocks().replaceBlock(y2, material);
                    replacedMaterial2 = biomeConfig.getReplaceBlocks().replaceBlock(y2, material2);
                }
                if (!this.isIcebergBlock(current, replacedMaterial, replacedMaterial2) && !current.isMaterial(LocalMaterials.SNOW_BLOCK)) continue;
                if (flag) {
                    world.setBlockDirect(x2, y2, z2, LocalMaterials.WATER);
                    continue;
                }
                world.setBlockDirect(x2, y2, z2, LocalMaterials.AIR);
                this.removeFloatingSnowLayer(world, x2, y2, z2);
            }
        }
    }

    private void removeFloatingSnowLayer(IWorldGenRegion world, int x, int y, int z) {
        LocalMaterialData materialAbove = world.getMaterialDirect(x, y + 1, z);
        if (materialAbove.isMaterial(LocalMaterials.SNOW)) {
            world.setBlockDirect(x, y + 1, z, LocalMaterials.AIR);
        }
    }

    private void generateIcebergBlock(IWorldGenRegion worldGenRegion, Random random, int x, int y, int z, int irandom, int x1, int y1, int z1, int irandom1, int irandom2, boolean flag, int irandom3, double drandom, boolean flag1, LocalMaterialData material, LocalMaterialData material2) {
        double signedDistance;
        double d = signedDistance = flag ? this.signedDistanceEllipse(x1, z1, 0, 0, 0, irandom2, this.getEllipseC(y1, irandom, irandom3), drandom) : this.signedDistanceCircle(x1, z1, 0, 0, 0, irandom1, random);
        if (signedDistance < 0.0) {
            double lvt_19_1_;
            int x2 = x + x1;
            int y2 = y + y1;
            int z2 = z + z1;
            double d2 = lvt_19_1_ = flag ? -0.5 : (double)(-6 - random.nextInt(3));
            if (signedDistance > lvt_19_1_ && random.nextDouble() > 0.9) {
                return;
            }
            this.setIcebergBlock(x2, y2, z2, worldGenRegion, random, irandom - y1, irandom, flag, flag1, material, material2);
        }
    }

    private void setIcebergBlock(int x, int y, int z, IWorldGenRegion world, Random random, int irandomy, int irandom, boolean flag, boolean flag1, LocalMaterialData material, LocalMaterialData material2) {
        LocalMaterialData current = world.getMaterialDirect(x, y, z);
        if (current.isAir() || current.isMaterial(LocalMaterials.SNOW_BLOCK) || current.isMaterial(LocalMaterials.ICE) || current.isMaterial(LocalMaterials.WATER)) {
            int irandom1;
            boolean flag2 = !flag || random.nextDouble() > 0.05;
            int n = irandom1 = flag ? 3 : 2;
            if (flag1 && !current.isMaterial(LocalMaterials.WATER) && (double)irandomy <= (double)random.nextInt(Math.max(1, irandom / irandom1)) + (double)irandom * 0.6 && flag2) {
                world.setBlockDirect(x, y, z, material2);
            } else {
                world.setBlockDirect(x, y, z, material);
            }
        }
    }

    private int getEllipseC(int y1, int irandom1, int irandom2) {
        int ellipsec = irandom2;
        if (y1 > 0 && irandom1 - y1 <= 3) {
            ellipsec -= 4 - (irandom1 - y1);
        }
        return ellipsec;
    }

    private double signedDistanceCircle(int x1, int z1, int x, int y, int z, int irandom, Random random) {
        float frandom = 10.0f * MathHelper.clamp(random.nextFloat(), 0.2f, 0.8f) / (float)irandom;
        return (double)frandom + Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) - Math.pow(irandom, 2.0);
    }

    private double signedDistanceEllipse(int x1, int z1, int x, int y, int z, int irandom, int iellipsec, double drandom) {
        return Math.pow(((double)(x1 - x) * Math.cos(drandom) - (double)(z1 - z) * Math.sin(drandom)) / (double)irandom, 2.0) + Math.pow(((double)(x1 - x) * Math.sin(drandom) + (double)(z1 - z) * Math.cos(drandom)) / (double)iellipsec, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(Random random, int irandom1, int irandom2, int irandom3) {
        float frandom1 = 3.5f - random.nextFloat();
        float frandom2 = (1.0f - (float)Math.pow(irandom1, 2.0) / ((float)irandom2 * frandom1)) * (float)irandom3;
        if (irandom2 > 15 + random.nextInt(5)) {
            int irandom4 = irandom1 < 3 + random.nextInt(6) ? irandom1 / 2 : irandom1;
            frandom2 = (1.0f - (float)irandom4 / ((float)irandom2 * frandom1 * 0.4f)) * (float)irandom3;
        }
        return MathHelper.ceil(frandom2 / 2.0f);
    }

    private int heightDependentRadiusEllipse(int irandomy, int irandom1, int irandom2) {
        float frandom = (1.0f - (float)Math.pow(irandomy, 2.0) / ((float)irandom1 * 1.0f)) * (float)irandom2;
        return MathHelper.ceil(frandom / 2.0f);
    }

    private int heightDependentRadiusSteep(Random random, int random1, int random2, int random3) {
        float frandom = 1.0f + random.nextFloat() / 2.0f;
        float frandom1 = (1.0f - (float)random1 / ((float)random2 * frandom)) * (float)random3;
        return MathHelper.ceil(frandom1 / 2.0f);
    }

    private boolean isIcebergBlock(LocalMaterialData target, LocalMaterialData material, LocalMaterialData material2) {
        return target.isMaterial(material) || target.isMaterial(material2);
    }

    private boolean belowIsAir(IWorldGenRegion world, int x, int y, int z) {
        return world.getMaterialDirect(x, y - 1, z).isAir();
    }

    private void smooth(IWorldGenRegion world, int x, int y, int z, int irandom1, int ismoothheight, boolean flag, int irandom3, LocalMaterialData material, LocalMaterialData material2) {
        int iradius = flag ? irandom3 : irandom1 / 2;
        for (int x1 = -iradius; x1 <= iradius; ++x1) {
            for (int z1 = -iradius; z1 <= iradius; ++z1) {
                for (int y1 = 0; y1 <= ismoothheight; ++y1) {
                    LocalMaterialData current;
                    int x2 = x + x1;
                    int y2 = y + y1;
                    int z2 = z + z1;
                    IBiomeConfig biomeConfig = world.getCachedBiomeProvider().getBiomeConfig(x2, z2, true);
                    LocalMaterialData replacedMaterial = material;
                    LocalMaterialData replacedMaterial2 = material2;
                    if (biomeConfig.getReplaceBlocks() != null) {
                        replacedMaterial = biomeConfig.getReplaceBlocks().replaceBlock(y2, material);
                        replacedMaterial2 = biomeConfig.getReplaceBlocks().replaceBlock(y2, material2);
                    }
                    if (!this.isIcebergBlock(current = world.getMaterialDirect(x2, y2, z2), replacedMaterial, replacedMaterial2) && !current.isMaterial(LocalMaterials.SNOW)) continue;
                    if (this.belowIsAir(world, x2, y2, z2)) {
                        world.setBlockDirect(x2, y2, z2, LocalMaterials.AIR);
                        world.setBlockDirect(x2, y2 + 1, z2, LocalMaterials.AIR);
                        continue;
                    }
                    if (!this.isIcebergBlock(current, replacedMaterial, replacedMaterial2)) continue;
                    LocalMaterialData[] materials = new LocalMaterialData[]{world.getMaterialDirect(x2 - 1, y2, z2), world.getMaterialDirect(x2 + 1, y2, z2), world.getMaterialDirect(x2, y2, z2 - 1), world.getMaterialDirect(x2, y2, z2 + 1)};
                    IBiomeConfig[] biomeConfigs = new IBiomeConfig[]{world.getCachedBiomeProvider().getBiomeConfig(x2 - 1, z2, true), world.getCachedBiomeProvider().getBiomeConfig(x2 + 1, z2, true), world.getCachedBiomeProvider().getBiomeConfig(x2, z2 - 1, true), world.getCachedBiomeProvider().getBiomeConfig(x2, z2 + 1, true)};
                    int iheight = 0;
                    int i = 0;
                    for (LocalMaterialData mat : materials) {
                        if (biomeConfigs[i].getReplaceBlocks() != null) {
                            replacedMaterial = biomeConfigs[i].getReplaceBlocks().replaceBlock(y2, material);
                            replacedMaterial2 = biomeConfigs[i].getReplaceBlocks().replaceBlock(y2, material2);
                        }
                        if (!this.isIcebergBlock(mat, replacedMaterial, replacedMaterial2)) {
                            ++iheight;
                        }
                        ++i;
                    }
                    if (iheight < 3) continue;
                    world.setBlockDirect(x2, y2, z2, LocalMaterials.AIR);
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Iceberg(");
        for (int i = 0; i < this.materials.length; ++i) {
            builder.append(this.materials[i] + ", ");
            builder.append(this.materials2[i] + ", ");
            builder.append(this.rarities[i] + ", ");
        }
        builder.append(this.totalRarity + ")");
        return builder.toString();
    }
}

