/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialProperties;
import java.util.List;
import java.util.Random;

public class KelpResource
extends FrequencyResourceBase {
    public KelpResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.frequency = this.readInt(args.get(0), 1, 500);
        this.rarity = this.readRarity(args.get(1));
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        int dy;
        int y = world.getBlockAboveSolidHeight(x, z);
        LocalMaterialData below = world.getMaterial(x, y - 1, z);
        if (below == null || !below.isSolid()) {
            return;
        }
        int height = 1 + random.nextInt(10);
        for (int y1 = 0; y1 <= height && world.getMaterial(x, dy = y + y1, z).isLiquid(); ++y1) {
            if (!world.getMaterial(x, dy + 1, z).isLiquid()) {
                if (y1 <= 0) break;
                world.setBlock(x, dy, z, LocalMaterials.KELP.withProperty(MaterialProperties.AGE_0_25, 20 + random.nextInt(4)));
                break;
            }
            if (y1 == height) {
                world.setBlock(x, dy, z, LocalMaterials.KELP.withProperty(MaterialProperties.AGE_0_25, 20 + random.nextInt(4)));
                continue;
            }
            world.setBlock(x, dy, z, LocalMaterials.KELP_PLANT);
        }
    }

    @Override
    public String toString() {
        return "Kelp(" + this.frequency + ", " + this.rarity + ")";
    }
}

