/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class OreResource
extends BiomeResourceBase
implements IBasicResource {
    private final int frequency;
    private final double rarity;
    private final LocalMaterialData material;
    private final int maxAltitude;
    private final int numberOfBlocks;
    private final int minAltitude;
    private final MaterialSet sourceBlocks;
    private final boolean useExtendedParams;
    private final int maxSpawn;

    public OreResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(7, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.numberOfBlocks = this.readInt(args.get(1), 1, 128);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.minAltitude = this.readInt(args.get(4), 0, 255);
        this.maxAltitude = this.readInt(args.get(5), this.minAltitude, 255);
        boolean useExtendedParams = false;
        int maxSpawn = 0;
        if (args.get(args.size() - 2).toLowerCase().trim().equals("true")) {
            try {
                maxSpawn = this.readInt(args.get(args.size() - 1), 0, Integer.MAX_VALUE);
                args = args.subList(0, args.size() - 2);
                useExtendedParams = true;
            }
            catch (InvalidConfigException invalidConfigException) {
                // empty catch block
            }
        }
        this.useExtendedParams = useExtendedParams;
        this.maxSpawn = maxSpawn;
        this.sourceBlocks = this.readMaterials(args, 6, materialReader);
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion worldGenRegion, Random random, ILogger logger, IMaterialReader materialReader) {
        int chunkX = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterX();
        int chunkZ = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterZ();
        int startX = worldGenRegion.getDecorationArea().getLeft();
        int startZ = worldGenRegion.getDecorationArea().getTop();
        int width = worldGenRegion.getDecorationArea().getWidth();
        int height = worldGenRegion.getDecorationArea().getHeight();
        byte[] highestBlocksCache = new byte[width * height];
        int spawned = 0;
        for (int t = 0; t < this.frequency; ++t) {
            int z;
            if (random.nextDouble() * 100.0 > this.rarity) continue;
            int x = chunkX + random.nextInt(16);
            if (this.spawn(worldGenRegion, random, false, x, z = chunkZ + random.nextInt(16), highestBlocksCache, width, height, startX, startZ)) {
                ++spawned;
            }
            if (this.maxSpawn <= 0 || spawned != this.maxSpawn) continue;
            return;
        }
    }

    public boolean spawn(IWorldGenRegion worldGenRegion, Random rand, boolean villageInChunk, int x, int z, byte[] highestBlocksCache, int width, int height, int startX, int startZ) {
        if (worldGenRegion.getWorldConfig().isDisableOreGen() && this.material.isOre()) {
            return true;
        }
        float randomAngle = rand.nextFloat() * (float)Math.PI;
        double randomX1 = (float)x - MathHelper.sin(randomAngle) * (float)this.numberOfBlocks / 8.0f;
        double randomX2 = (float)x + MathHelper.sin(randomAngle) * (float)this.numberOfBlocks / 8.0f;
        double randomZ1 = (float)z - MathHelper.cos(randomAngle) * (float)this.numberOfBlocks / 8.0f;
        double randomZ2 = (float)z + MathHelper.cos(randomAngle) * (float)this.numberOfBlocks / 8.0f;
        int randomY = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        double randomY1 = randomY + rand.nextInt(3) - 2;
        double randomY2 = randomY + rand.nextInt(3) - 2;
        boolean hasSpawned = false;
        for (int currentNumberOfBlocks = 0; currentNumberOfBlocks < this.numberOfBlocks; ++currentNumberOfBlocks) {
            float currentNumberOfBlocksFraction = (float)currentNumberOfBlocks / (float)this.numberOfBlocks;
            double xCenter = randomX2 + (randomX1 - randomX2) * (double)currentNumberOfBlocksFraction;
            double yCenter = randomY2 + (randomY1 - randomY2) * (double)currentNumberOfBlocksFraction;
            double zCenter = randomZ2 + (randomZ1 - randomZ2) * (double)currentNumberOfBlocksFraction;
            double randomSize = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double xzRadius = ((double)(MathHelper.sin((float)Math.PI * currentNumberOfBlocksFraction) + 1.0f) * randomSize + 1.0) / 2.0;
            double yRadius = ((double)(MathHelper.sin((float)Math.PI * currentNumberOfBlocksFraction) + 1.0f) * randomSize + 1.0) / 2.0;
            int startWorldX = MathHelper.floor(xCenter - xzRadius);
            int startWorldY = MathHelper.floor(yCenter - yRadius);
            int startWorldZ = MathHelper.floor(zCenter - xzRadius);
            int endWorldX = MathHelper.floor(xCenter + xzRadius);
            int endWorldY = MathHelper.floor(yCenter + yRadius);
            int endWorldZ = MathHelper.floor(zCenter + xzRadius);
            if (!worldGenRegion.getDecorationArea().isInAreaBeingDecorated(startWorldX, startWorldZ) || !worldGenRegion.getDecorationArea().isInAreaBeingDecorated(endWorldX, endWorldZ) || endWorldY < 0 || startWorldY >= 256) continue;
            if (startWorldY < 0) {
                startWorldY = 0;
            }
            if (endWorldY >= 256) {
                endWorldY = 256;
            }
            block1: for (int worldX = startWorldX; worldX <= endWorldX; ++worldX) {
                double xDistanceToCenterFraction = ((double)worldX + 0.5 - xCenter) / xzRadius;
                if (!(xDistanceToCenterFraction * xDistanceToCenterFraction < 1.0)) continue;
                for (int worldZ = startWorldZ; worldZ <= endWorldZ; ++worldZ) {
                    double zDistanceToCenterFraction = ((double)worldZ + 0.5 - zCenter) / xzRadius;
                    if (!(xDistanceToCenterFraction * xDistanceToCenterFraction + zDistanceToCenterFraction * zDistanceToCenterFraction < 1.0)) continue;
                    if (endWorldY > 63) {
                        int highestSolidBlock = highestBlocksCache[(worldX - startX) * height + (worldZ - startZ)] & 0xFF;
                        if (highestSolidBlock == 0) {
                            highestSolidBlock = worldGenRegion.getHeightMapHeight(worldX, worldZ);
                            if (highestSolidBlock == -1) {
                                highestSolidBlock = 0;
                                continue block1;
                            }
                            highestBlocksCache[(worldX - startX) * height + (worldZ - startZ)] = (byte)highestSolidBlock;
                        }
                        if (endWorldY > highestSolidBlock) {
                            endWorldY = highestSolidBlock;
                        }
                    }
                    for (int worldY = startWorldY; worldY <= endWorldY; ++worldY) {
                        double yDistanceToCenterFraction = ((double)worldY + 0.5 - yCenter) / yRadius;
                        if (!(xDistanceToCenterFraction * xDistanceToCenterFraction + yDistanceToCenterFraction * yDistanceToCenterFraction + zDistanceToCenterFraction * zDistanceToCenterFraction < 1.0) || !this.sourceBlocks.contains(worldGenRegion.getMaterial(worldX, worldY, worldZ))) continue;
                        worldGenRegion.setBlock(worldX, worldY, worldZ, this.material);
                        hasSpawned = true;
                    }
                }
            }
        }
        return hasSpawned;
    }

    @Override
    public String toString() {
        return "Ore(" + this.material + "," + this.numberOfBlocks + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + (this.useExtendedParams ? ",true," + this.maxSpawn : "") + ")";
    }
}

