/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.gen.resource.util.BerryBush;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import com.pg85.otg.util.minecraft.PlantType;
import java.util.List;
import java.util.Random;

public class PlantResource
extends FrequencyResourceBase {
    private final int maxAltitude;
    private final int minAltitude;
    private final PlantType plant;
    private final MaterialSet sourceBlocks;
    private BerryBush.SparseOption sparseOption = null;

    public PlantResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(6, args);
        this.plant = PlantType.getPlant(args.get(0), materialReader);
        int i = 0;
        if (args.get(1).equalsIgnoreCase("Sparse") || args.get(1).equalsIgnoreCase("Decorated")) {
            this.sparseOption = args.get(1).equalsIgnoreCase("Sparse") ? BerryBush.SparseOption.Sparse : BerryBush.SparseOption.Decorated;
            i = 1;
        }
        this.frequency = this.readInt(args.get(1 + i), 1, 100);
        this.rarity = this.readRarity(args.get(2 + i));
        this.minAltitude = this.readInt(args.get(3 + i), 0, 255);
        this.maxAltitude = this.readInt(args.get(4 + i), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 5 + i, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion worldGenregion, Random rand, int x, int z) {
        if (this.sparseOption != null && this.plant == PlantType.BerryBush) {
            BerryBush.spawnBerryBushes(worldGenregion, rand, x, z, this.plant, this.frequency, this.minAltitude, this.maxAltitude, this.sourceBlocks, this.sparseOption);
            return;
        }
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        for (int i = 0; i < 64; ++i) {
            int localX = x + rand.nextInt(8) - rand.nextInt(8);
            int localY = y + rand.nextInt(4) - rand.nextInt(4);
            int localZ = z + rand.nextInt(8) - rand.nextInt(8);
            LocalMaterialData worldMaterial = worldGenregion.getMaterial(localX, localY, localZ);
            LocalMaterialData worldMaterialBelow = worldGenregion.getMaterial(localX, localY - 1, localZ);
            if (worldMaterial == null || !worldMaterial.isAir() || worldMaterialBelow == null || !this.sourceBlocks.contains(worldMaterialBelow)) continue;
            this.plant.spawn(worldGenregion, localX, localY, localZ);
        }
    }

    @Override
    public String toString() {
        String sparse = this.sparseOption == null ? "" : (Object)((Object)this.sparseOption) + ",";
        return "Plant(" + this.plant.getName() + "," + sparse + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }
}

