/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import java.util.List;

public class RegistryResource
extends BiomeResourceBase {
    private final String registryKey;
    private final String decorationStage;

    public RegistryResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(1, args);
        this.registryKey = args.get(0);
        this.decorationStage = args.size() > 1 ? args.get(1) : "VEGETAL_DECORATION";
    }

    public String getDecorationStage() {
        return this.decorationStage;
    }

    public String getFeatureKey() {
        return this.registryKey;
    }

    @Override
    public String toString() {
        return "Registry(" + this.registryKey + "," + this.decorationStage + ")";
    }
}

