/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.List;
import java.util.Random;

public class SeaGrassResource
extends FrequencyResourceBase {
    private final double tallChance;

    public SeaGrassResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.frequency = this.readInt(args.get(0), 1, 500);
        this.rarity = this.readRarity(args.get(1));
        this.tallChance = this.readDouble(args.get(2), 0.0, 1.0);
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        int y = world.getBlockAboveSolidHeight(x, z);
        LocalMaterialData below = world.getMaterial(x, y - 1, z);
        if (below == null || !below.isSolid()) {
            return;
        }
        LocalMaterialData material = world.getMaterial(x, y, z);
        if (material == null) {
            return;
        }
        if (material.isLiquid()) {
            if (random.nextDouble() <= this.tallChance && world.getMaterial(x, y + 1, z).isLiquid()) {
                world.setBlock(x, y, z, LocalMaterials.TALL_SEAGRASS_LOWER);
                world.setBlock(x, y + 1, z, LocalMaterials.TALL_SEAGRASS_UPPER);
            } else {
                world.setBlock(x, y, z, LocalMaterials.SEAGRASS);
            }
        }
    }

    @Override
    public String toString() {
        return "SeaGrass(" + this.frequency + "," + this.rarity + "," + this.tallChance + ")";
    }
}

