/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialProperties;
import java.util.List;
import java.util.Random;

public class SeaPickleResource
extends FrequencyResourceBase {
    private final int attempts;

    public SeaPickleResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.frequency = this.readInt(args.get(0), 1, 500);
        this.rarity = this.readRarity(args.get(1));
        this.attempts = this.readInt(args.get(2), 1, 256);
    }

    @Override
    public void spawn(IWorldGenRegion world, Random random, int x, int z) {
        for (int i = 0; i < this.attempts; ++i) {
            int dx = x + random.nextInt(8) - random.nextInt(8);
            int dz = z + random.nextInt(8) - random.nextInt(8);
            int y = world.getBlockAboveSolidHeight(dx, dz);
            LocalMaterialData bottom = world.getMaterial(dx, y - 1, dz);
            LocalMaterialData here = world.getMaterial(dx, y, dz);
            if (bottom == null || here == null || !bottom.isSolid() || !here.isLiquid()) continue;
            world.setBlock(dx, y, dz, LocalMaterials.SEA_PICKLE.withProperty(MaterialProperties.PICKLES_1_4, random.nextInt(4) + 1));
        }
    }

    @Override
    public String toString() {
        return "SeaPickle(" + this.frequency + "," + this.rarity + "," + this.attempts + ")";
    }
}

