/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.List;
import java.util.Random;

public class SmallLakeResource
extends FrequencyResourceBase {
    private final LocalMaterialData material;
    private final int maxAltitude;
    private final int minAltitude;

    public SmallLakeResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(5, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 255);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 255);
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion worldGenRegion, Random random, ILogger logger, IMaterialReader materialReader) {
        if (worldGenRegion.chunkHasDefaultStructure(random, worldGenRegion.getDecorationArea().getChunkBeingDecorated())) {
            return;
        }
        super.spawnForChunkDecoration(worldGenRegion, random, logger, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion world, Random rand, int x, int z) {
        int lakeY;
        int lakeZ;
        int lakeX;
        LocalMaterialData worldMaterial;
        int y;
        for (y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude); y > 5 && (worldMaterial = world.getMaterial(x, y, z)) != null && worldMaterial.isAir(); --y) {
        }
        if (y <= 4) {
            return;
        }
        y -= 4;
        LocalMaterialData air = LocalMaterials.AIR;
        boolean[] lakeMask = new boolean[2048];
        for (int j = 0; j < rand.nextInt(4) + 4; ++j) {
            double lakeSizeX = rand.nextDouble() * 6.0 + 3.0;
            double lakeSizeY = rand.nextDouble() * 4.0 + 2.0;
            double lakeSizeZ = rand.nextDouble() * 6.0 + 3.0;
            double scaledLakeX = rand.nextDouble() * (16.0 - lakeSizeX - 2.0) + 1.0 + lakeSizeX / 2.0;
            double scaledLakeY = rand.nextDouble() * (8.0 - lakeSizeY - 4.0) + 2.0 + lakeSizeY / 2.0;
            double scaledLakeZ = rand.nextDouble() * (16.0 - lakeSizeZ - 2.0) + 1.0 + lakeSizeZ / 2.0;
            for (int lakeX2 = 1; lakeX2 < 15; ++lakeX2) {
                for (int lakeZ2 = 1; lakeZ2 < 15; ++lakeZ2) {
                    for (int lakeY2 = 1; lakeY2 < 7; ++lakeY2) {
                        double distX = ((double)lakeX2 - scaledLakeX) / (lakeSizeX / 2.0);
                        double distY = ((double)lakeY2 - scaledLakeY) / (lakeSizeY / 2.0);
                        double distZ = ((double)lakeZ2 - scaledLakeZ) / (lakeSizeZ / 2.0);
                        double distance = distX * distX + distY * distY + distZ * distZ;
                        if (distance >= 1.0) continue;
                        lakeMask[(lakeX2 * 16 + lakeZ2) * 8 + lakeY2] = true;
                    }
                }
            }
        }
        for (lakeX = 0; lakeX < 16; ++lakeX) {
            for (lakeZ = 0; lakeZ < 16; ++lakeZ) {
                for (lakeY = 0; lakeY < 8; ++lakeY) {
                    boolean flag;
                    boolean bl = flag = !lakeMask[(lakeX * 16 + lakeZ) * 8 + lakeY] && (lakeX < 15 && lakeMask[((lakeX + 1) * 16 + lakeZ) * 8 + lakeY] || lakeX > 0 && lakeMask[((lakeX - 1) * 16 + lakeZ) * 8 + lakeY] || lakeZ < 15 && lakeMask[(lakeX * 16 + (lakeZ + 1)) * 8 + lakeY] || lakeZ > 0 && lakeMask[(lakeX * 16 + (lakeZ - 1)) * 8 + lakeY] || lakeY < 7 && lakeMask[(lakeX * 16 + lakeZ) * 8 + (lakeY + 1)] || lakeY > 0 && lakeMask[(lakeX * 16 + lakeZ) * 8 + (lakeY - 1)]);
                    if (!flag) continue;
                    LocalMaterialData localMaterialData = world.getMaterial(x + lakeX, y + lakeY, z + lakeZ);
                    if (lakeY >= 4 && (localMaterialData == null || localMaterialData.isLiquid())) {
                        return;
                    }
                    LocalMaterialData localMaterialData2 = world.getMaterial(x + lakeX, y + lakeY, z + lakeZ);
                    if (lakeY >= 4 || localMaterialData != null && localMaterialData.isSolid() || localMaterialData2 != null && localMaterialData2.equals(this.material)) continue;
                    return;
                }
            }
        }
        for (lakeX = 0; lakeX < 16; ++lakeX) {
            for (lakeZ = 0; lakeZ < 16; ++lakeZ) {
                for (lakeY = 0; lakeY < 4; ++lakeY) {
                    if (!lakeMask[(lakeX * 16 + lakeZ) * 8 + lakeY]) continue;
                    world.setBlock(x + lakeX, y + lakeY, z + lakeZ, this.material);
                    lakeMask[(lakeX * 16 + lakeZ) * 8 + lakeY] = false;
                }
                for (lakeY = 4; lakeY < 8; ++lakeY) {
                    if (!lakeMask[(lakeX * 16 + lakeZ) * 8 + lakeY]) continue;
                    world.setBlock(x + lakeX, y + lakeY, z + lakeZ, air);
                    lakeMask[(lakeX * 16 + lakeZ) * 8 + lakeY] = false;
                }
            }
        }
    }

    @Override
    public String toString() {
        return "SmallLake(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }
}

