/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.noise.legacy.NoiseGeneratorSurfacePatchOctaves;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import com.pg85.otg.util.minecraft.PlantType;
import java.util.List;
import java.util.Random;

public class SurfacePatchResource
extends BiomeResourceBase
implements IBasicResource {
    private final LocalMaterialData material;
    private final PlantType decorationAboveReplacementPlant;
    private final LocalMaterialData decorationAboveReplacements;
    private final int maxAltitude;
    private final int minAltitude;
    private final NoiseGeneratorSurfacePatchOctaves noiseGen;
    private final Random random;
    private final MaterialSet sourceBlocks;

    public SurfacePatchResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(4, args);
        this.material = materialReader.readMaterial(args.get(0));
        String secondArgument = args.get(1);
        PlantType plantType = null;
        try {
            this.readInt(secondArgument, 0, 16);
            plantType = PlantType.getPlant(args.get(1) + ":" + secondArgument, materialReader);
        }
        catch (InvalidConfigException e) {
            plantType = PlantType.getPlant(args.get(1), materialReader);
        }
        this.decorationAboveReplacementPlant = plantType;
        this.decorationAboveReplacements = this.decorationAboveReplacementPlant == null ? materialReader.readMaterial(args.get(1)) : null;
        this.minAltitude = this.readInt(args.get(2), 0, 255);
        this.maxAltitude = this.readInt(args.get(3), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 4, materialReader);
        this.random = new Random(2345L);
        this.noiseGen = new NoiseGeneratorSurfacePatchOctaves(this.random, 1);
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion worldGenRegion, Random random, ILogger logger, IMaterialReader materialReader) {
        int chunkX = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterX();
        int chunkZ = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterZ();
        for (int z0 = 0; z0 < 16; ++z0) {
            for (int x0 = 0; x0 < 16; ++x0) {
                int x = chunkX + x0;
                int z = chunkZ + z0;
                this.spawn(worldGenRegion, random, false, x, z);
            }
        }
    }

    public void spawn(IWorldGenRegion worldGenRegion, Random rand, boolean villageInChunk, int x, int z) {
        LocalMaterialData materialAtLocation;
        int y = worldGenRegion.getHighestBlockAboveYAt(x, z) - 1;
        if (y < this.minAltitude || y > this.maxAltitude) {
            return;
        }
        double yNoise = this.noiseGen.getYNoise((double)x * 0.25, (double)z * 0.25);
        if (yNoise > 0.0 && this.sourceBlocks.contains(materialAtLocation = worldGenRegion.getMaterial(x, y, z))) {
            ReplaceBlockMatrix replaceBlocks = worldGenRegion.getBiomeConfigForDecoration(x, z).getReplaceBlocks();
            worldGenRegion.setBlock(x, y, z, this.material, replaceBlocks);
            if (yNoise < 0.12) {
                if (this.decorationAboveReplacementPlant != null) {
                    this.decorationAboveReplacementPlant.spawn(worldGenRegion, x, y + 1, z);
                } else if (this.decorationAboveReplacements != null) {
                    worldGenRegion.setBlock(x, y + 1, z, this.decorationAboveReplacements, replaceBlocks);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "SurfacePatch(" + this.material + "," + (this.decorationAboveReplacementPlant != null ? this.decorationAboveReplacementPlant : this.decorationAboveReplacements) + "," + this.minAltitude + "," + this.maxAltitude + "," + this.sourceBlocks + ")";
    }
}

