/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class UnderWaterOreResource
extends FrequencyResourceBase {
    private final LocalMaterialData material;
    private final int size;
    private final MaterialSet sourceBlocks;

    public UnderWaterOreResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(5, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.size = this.readInt(args.get(1), 1, 8);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.sourceBlocks = this.readMaterials(args, 4, materialReader);
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random rand, int x, int z) {
        int firstSolidBlock = worldGenRegion.getBlockAboveSolidHeight(x, z) - 1;
        if (worldGenRegion.getBlockAboveLiquidHeight(x, z) < firstSolidBlock || firstSolidBlock == -1) {
            return;
        }
        if (worldGenRegion.getWorldConfig().isDisableOreGen() && this.material.isOre()) {
            return;
        }
        int currentSize = rand.nextInt(this.size) + 2;
        for (int currentX = x - currentSize; currentX <= x + currentSize; ++currentX) {
            for (int currentZ = z - currentSize; currentZ <= z + currentSize; ++currentZ) {
                int deltaX = currentX - x;
                int deltaZ = currentZ - z;
                if (!worldGenRegion.getDecorationArea().isInAreaBeingDecorated(currentX, currentZ)) continue;
                IBiomeConfig biome = worldGenRegion.getBiomeConfigForDecoration(currentX, currentZ);
                if (deltaX * deltaX + deltaZ * deltaZ > currentSize * currentSize) continue;
                for (int y = firstSolidBlock - 2; y <= firstSolidBlock + 2; ++y) {
                    LocalMaterialData sourceBlock = worldGenRegion.getMaterial(currentX, y, currentZ);
                    if (!this.sourceBlocks.contains(sourceBlock)) continue;
                    worldGenRegion.setBlock(currentX, y, currentZ, this.material, biome.getReplaceBlocks());
                }
            }
        }
    }

    @Override
    public String toString() {
        return "UnderWaterOre(" + this.material + "," + this.size + "," + this.frequency + "," + this.rarity + this.makeMaterials(this.sourceBlocks) + ")";
    }
}

