/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.FrequencyResourceBase;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.List;
import java.util.Random;

public class UndergroundLakeResource
extends FrequencyResourceBase {
    private final int maxAltitude;
    private final int maxSize;
    private final int minAltitude;
    private final int minSize;

    public UndergroundLakeResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(6, args);
        this.minSize = this.readInt(args.get(0), 1, 25);
        this.maxSize = this.readInt(args.get(1), this.minSize, 60);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.minAltitude = this.readInt(args.get(4), 0, 255);
        this.maxAltitude = this.readInt(args.get(5), this.minAltitude, 255);
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random rand, int x, int z) {
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        if (y >= worldGenRegion.getHighestBlockAboveYAt(x, z)) {
            return;
        }
        int size = RandomHelper.numberInRange(rand, this.minSize, this.maxSize);
        float mPi = rand.nextFloat() * 3.141593f;
        double x1 = (float)(x + 8) + MathHelper.sin(mPi) * (float)size / 8.0f;
        double x2 = (float)(x + 8) - MathHelper.sin(mPi) * (float)size / 8.0f;
        double z1 = (float)(z + 8) + MathHelper.cos(mPi) * (float)size / 8.0f;
        double z2 = (float)(z + 8) - MathHelper.cos(mPi) * (float)size / 8.0f;
        double y1 = y + rand.nextInt(3) + 2;
        double y2 = y + rand.nextInt(3) + 2;
        for (int i = 0; i <= size; ++i) {
            double xAdjusted = x1 + (x2 - x1) * (double)i / (double)size;
            double yAdjusted = y1 + (y2 - y1) * (double)i / (double)size;
            double zAdjusted = z1 + (z2 - z1) * (double)i / (double)size;
            double horizontalSizeMultiplier = rand.nextDouble() * (double)size / 16.0;
            double verticalSizeMultiplier = rand.nextDouble() * (double)size / 32.0;
            double horizontalSize = (double)(MathHelper.sin((float)i * 3.141593f / (float)size) + 1.0f) * horizontalSizeMultiplier + 1.0;
            double verticalSize = (double)(MathHelper.sin((float)i * 3.141593f / (float)size) + 1.0f) * verticalSizeMultiplier + 1.0;
            for (int xLake = (int)(xAdjusted - horizontalSize / 2.0); xLake <= (int)(xAdjusted + horizontalSize / 2.0); ++xLake) {
                for (int yLake = (int)(yAdjusted - verticalSize / 2.0); yLake <= (int)(yAdjusted + verticalSize / 2.0); ++yLake) {
                    for (int zLake = (int)(zAdjusted - horizontalSize / 2.0); zLake <= (int)(zAdjusted + horizontalSize / 2.0); ++zLake) {
                        double zBounds;
                        double yBounds;
                        double xBounds;
                        LocalMaterialData material = worldGenRegion.getMaterial(xLake, yLake, zLake);
                        if (material == null || material.isEmptyOrAir() || material.isMaterial(LocalMaterials.BEDROCK) || (xBounds = ((double)xLake + 0.5 - xAdjusted) / (horizontalSize / 2.0)) * xBounds + (yBounds = ((double)yLake + 0.5 - yAdjusted) / (verticalSize / 2.0)) * yBounds + (zBounds = ((double)zLake + 0.5 - zAdjusted) / (horizontalSize / 2.0)) * zBounds >= 1.0) continue;
                        LocalMaterialData materialBelow = worldGenRegion.getMaterial(xLake, yLake - 1, zLake);
                        if (materialBelow != null && materialBelow.isAir()) {
                            worldGenRegion.setBlock(xLake, yLake, zLake, LocalMaterials.AIR);
                            continue;
                        }
                        worldGenRegion.setBlock(xLake, yLake, zLake, LocalMaterials.WATER);
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "UnderGroundLake(" + this.minSize + "," + this.maxSize + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }
}

