/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource;

import com.pg85.otg.config.biome.BiomeResourceBase;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.resource.IBasicResource;
import com.pg85.otg.gen.resource.Vein;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class VeinResource
extends BiomeResourceBase
implements IBasicResource {
    final LocalMaterialData material;
    final int maxAltitude;
    final int minAltitude;
    final int oreFrequency;
    final int oreRarity;
    final int oreAvgSize;
    final MaterialSet sourceBlocks;
    private final int maxSizeInBlocks;
    private final int minSizeInBlocks;
    private final double veinRarity;

    public VeinResource(IBiomeConfig biomeConfig, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        super(biomeConfig, args, logger, materialReader);
        this.assureSize(9, args);
        this.material = materialReader.readMaterial(args.get(0));
        this.minSizeInBlocks = this.readInt(args.get(1), 10, 200);
        this.maxSizeInBlocks = this.readInt(args.get(2), this.minSizeInBlocks, 201);
        this.veinRarity = this.readDouble(args.get(3), 1.0E-7, 100.0);
        this.oreAvgSize = this.readInt(args.get(4), 1, 64);
        this.oreFrequency = this.readInt(args.get(5), 1, 100);
        this.oreRarity = this.readInt(args.get(6), 1, 100);
        this.minAltitude = this.readInt(args.get(7), 0, 255);
        this.maxAltitude = this.readInt(args.get(8), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 9, materialReader);
    }

    private Vein getVeinStartInChunk(IWorldGenRegion worldGenRegion, int chunkX, int chunkZ) {
        Random random = RandomHelper.getRandomForCoords(chunkX, chunkZ, (long)(this.material.hashCode() * (this.minSizeInBlocks + this.maxSizeInBlocks + 100)) + worldGenRegion.getSeed());
        if (random.nextDouble() * 100.0 < this.veinRarity) {
            int veinX = chunkX * 16 + random.nextInt(16) + 8;
            int veinY = RandomHelper.numberInRange(random, this.minAltitude, this.maxAltitude);
            int veinZ = chunkZ * 16 + random.nextInt(16) + 8;
            int veinSize = RandomHelper.numberInRange(random, this.minSizeInBlocks, this.maxSizeInBlocks);
            return new Vein(veinX, veinY, veinZ, veinSize);
        }
        return null;
    }

    @Override
    public void spawnForChunkDecoration(IWorldGenRegion worldGenRegion, Random random, ILogger logger, IMaterialReader materialReader) {
        int searchRadius = (this.maxSizeInBlocks + 15) / 16;
        if (worldGenRegion.getWorldConfig().isDisableOreGen() && this.material.isOre()) {
            return;
        }
        int currentChunkX = worldGenRegion.getDecorationArea().getChunkBeingDecorated().getChunkX();
        int currentChunkZ = worldGenRegion.getDecorationArea().getChunkBeingDecorated().getChunkZ();
        for (int searchChunkX = currentChunkX - searchRadius; searchChunkX < currentChunkX + searchRadius; ++searchChunkX) {
            for (int searchChunkZ = currentChunkZ - searchRadius; searchChunkZ < currentChunkZ + searchRadius; ++searchChunkZ) {
                Vein vein = this.getVeinStartInChunk(worldGenRegion, searchChunkX, searchChunkZ);
                if (vein == null || !vein.reachesChunk(currentChunkX, currentChunkZ)) continue;
                vein.spawn(worldGenRegion, random, this);
            }
        }
    }

    @Override
    public String toString() {
        return "Vein(" + this.material + "," + this.minSizeInBlocks + "," + this.maxSizeInBlocks + "," + this.veinRarity + "," + this.oreAvgSize + "," + this.oreFrequency + "," + this.oreRarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }
}

