/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.resource.util;

import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialProperties;
import com.pg85.otg.util.materials.MaterialSet;
import com.pg85.otg.util.minecraft.PlantType;
import java.util.Random;

public class BerryBush {
    public static void spawnBerryBushes(IWorldGenRegion worldGenregion, Random random, int centerX, int centerZ, PlantType plant, int frequency, int minAltitude, int maxAltitude, MaterialSet sourceBlocks, SparseOption sparseOption) {
        LocalMaterialData worldMaterial;
        int centerY = worldGenregion.getHighestBlockAboveYAt(centerX, centerZ);
        if (centerY < 0) {
            return;
        }
        while (centerY >= 0 && centerY < 256 && (worldMaterial = worldGenregion.getMaterial(centerX, centerY, centerZ)) != null && (worldMaterial.isAir() || worldMaterial.isLeaves()) && worldGenregion.getMaterial(centerX, centerY - 1, centerZ) != null && centerY > 0) {
            --centerY;
        }
        ++centerY;
        int xzBounds = sparseOption == SparseOption.Sparse ? 7 : 5;
        int yBounds = sparseOption == SparseOption.Sparse ? 4 : 3;
        frequency += sparseOption == SparseOption.Sparse ? 0 : 10;
        for (int i = 0; i < frequency; ++i) {
            int z;
            int y;
            int x = centerX + random.nextInt(xzBounds) - random.nextInt(xzBounds);
            worldMaterial = worldGenregion.getMaterial(x, y = centerY + random.nextInt(yBounds) - random.nextInt(yBounds), z = centerZ + random.nextInt(xzBounds) - random.nextInt(xzBounds));
            if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterial = worldGenregion.getMaterial(x, y - 1, z)) == null || !sourceBlocks.contains(worldMaterial) || y < minAltitude || y >= maxAltitude) continue;
            if (plant == PlantType.BerryBush) {
                worldGenregion.setBlock(x, y, z, LocalMaterials.BERRY_BUSH.withProperty(MaterialProperties.AGE_0_3, random.nextInt(4)));
                continue;
            }
            plant.spawn(worldGenregion, x, y, z);
        }
    }

    public static enum SparseOption {
        Sparse,
        Decorated;

    }
}

