/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.surface;

import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialProperties;

public class FrozenSurfaceHelper {
    private static final int MAX_LAYERS_ON_LEAVES = 3;

    public static void freezeChunk(IWorldGenRegion worldGenRegion, ChunkCoordinate chunkCoord) {
        int x = chunkCoord.getChunkX() * 16 + 8;
        int z = chunkCoord.getChunkZ() * 16 + 8;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int blockToFreezeX = x + i;
                int blockToFreezeZ = z + j;
                FrozenSurfaceHelper.freezeColumn(worldGenRegion, blockToFreezeX, blockToFreezeZ);
            }
        }
    }

    private static void freezeColumn(IWorldGenRegion worldGenRegion, int x, int z) {
        IBiome biome = worldGenRegion.getBiomeForDecoration(x, z);
        if (biome != null) {
            IBiomeConfig biomeConfig = biome.getBiomeConfig();
            int blockToFreezeY = worldGenRegion.getHighestBlockAboveYAt(x, z);
            float tempAtBlockToFreeze = biome.getTemperatureAt(x, blockToFreezeY, z);
            if (blockToFreezeY > 0 && tempAtBlockToFreeze < 0.15f && !FrozenSurfaceHelper.freezeLiquid(biomeConfig, worldGenRegion, x, blockToFreezeY - 1, z, 0)) {
                FrozenSurfaceHelper.startSnowFall(biomeConfig, worldGenRegion, x, blockToFreezeY, z, biome);
            }
        }
    }

    private static boolean freezeLiquid(IBiomeConfig biomeConfig, IWorldGenRegion worldGenRegion, int x, int y, int z, int currentPropagationSize) {
        LocalMaterialData materialToFreeze;
        if (biomeConfig != null && (materialToFreeze = worldGenRegion.getMaterial(x, y, z)).isLiquid()) {
            LocalMaterialData iceBlock = biomeConfig.getIceBlockReplaced(y);
            if (FrozenSurfaceHelper.shouldFreeze(x, y, z, materialToFreeze, iceBlock, LocalMaterials.WATER)) {
                worldGenRegion.setBlock(x, y, z, iceBlock);
            } else {
                LocalMaterialData cooledLavaBlock = biomeConfig.getCooledLavaBlockReplaced(y);
                if (FrozenSurfaceHelper.shouldFreeze(x, y, z, materialToFreeze, cooledLavaBlock, LocalMaterials.LAVA)) {
                    worldGenRegion.setBlock(x, y, z, cooledLavaBlock);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean shouldFreeze(int x, int y, int z, LocalMaterialData thawedMaterial, LocalMaterialData frozenMaterial, LocalMaterialData source) {
        return thawedMaterial.isMaterial(source) && !frozenMaterial.isMaterial(source);
    }

    private static void startSnowFall(IBiomeConfig biomeConfig, IWorldGenRegion worldGenRegion, int x, int y, int z, IBiome biome) {
        int snowHeight;
        int decreaseFactor = 0;
        LocalMaterialData materialToSnowAt = null;
        LocalMaterialData materialToSnowOn = null;
        if (worldGenRegion.getWorldConfig().isBetterSnowFall()) {
            float tempAtBlockToFreeze = biome.getTemperatureAt(x, y, z);
            snowHeight = biomeConfig.getSnowHeight(tempAtBlockToFreeze);
        } else {
            snowHeight = 0;
        }
        while (y > 1 && decreaseFactor < 8 && snowHeight - decreaseFactor >= 0) {
            materialToSnowAt = worldGenRegion.getMaterial(x, y, z);
            materialToSnowOn = worldGenRegion.getMaterial(x, y - 1, z);
            if (materialToSnowAt != null && materialToSnowOn != null && materialToSnowAt.isAir() && materialToSnowOn.canSnowFallOn()) {
                if (FrozenSurfaceHelper.setSnowFallAtLocation(worldGenRegion, x, y, z, snowHeight - decreaseFactor, materialToSnowOn)) break;
                decreaseFactor += 3;
            }
            if (materialToSnowOn == null || materialToSnowOn.isSolid()) break;
            --y;
        }
    }

    private static boolean setSnowFallAtLocation(IWorldGenRegion worldGenRegion, int x, int y, int z, int baseSnowHeight, LocalMaterialData materialToSnowOn) {
        if (materialToSnowOn.isLeaves()) {
            LocalMaterialData snowMass = LocalMaterials.SNOW;
            worldGenRegion.setBlock(x, y, z, snowMass);
            return baseSnowHeight <= 2;
        }
        LocalMaterialData snowMass = LocalMaterials.SNOW;
        worldGenRegion.setBlock(x, y, z, snowMass);
        if (materialToSnowOn.isMaterial(LocalMaterials.GRASS) || materialToSnowOn.isMaterial(LocalMaterials.PODZOL)) {
            worldGenRegion.setBlock(x, y - 1, z, materialToSnowOn.withProperty(MaterialProperties.SNOWY, true));
        }
        return true;
    }
}

