/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.surface;

import com.google.common.collect.ImmutableList;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.noise.OctaveSimplexNoiseSampler;
import com.pg85.otg.gen.surface.MultipleLayersSurfaceGenerator;
import com.pg85.otg.gen.surface.MultipleLayersSurfaceGeneratorLayer;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.gen.GeneratingChunk;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public class IcebergSurfaceGenerator
extends MultipleLayersSurfaceGenerator {
    private OctaveSimplexNoiseSampler icebergNoise;
    private OctaveSimplexNoiseSampler icebergCutoffNoise;

    IcebergSurfaceGenerator(String[] args, IMaterialReader materialReader) throws InvalidConfigException {
        super(args, materialReader);
    }

    @Override
    protected void spawnColumn(long worldSeed, MultipleLayersSurfaceGeneratorLayer layer, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, IBiome biome, int xInWorld, int zInWorld) {
        Random random;
        int internalX = xInWorld & 0xF;
        int internalZ = zInWorld & 0xF;
        if (this.icebergNoise == null || this.icebergCutoffNoise == null) {
            random = new Random(worldSeed);
            this.icebergNoise = new OctaveSimplexNoiseSampler(random, IntStream.rangeClosed(-3, 0));
            this.icebergCutoffNoise = new OctaveSimplexNoiseSampler(random, (List<Integer>)ImmutableList.of((Object)0));
        }
        random = generatingChunk.random;
        IBiomeConfig biomeConfig = biome.getBiomeConfig();
        if (biomeConfig.isCeilingBedrock()) {
            chunkBuffer.setBlock(internalX, generatingChunk.heightCap - 2, internalZ, biomeConfig.getBedrockBlockReplaced(generatingChunk.heightCap - 2));
        }
        double icebergHeight = 0.0;
        double icebergDepth = 0.0;
        int seaLevel = generatingChunk.getWaterLevel(internalX, internalZ);
        double noise = generatingChunk.getNoise(internalX, internalZ);
        float temperature = biome.getTemperatureAt(xInWorld, biomeConfig.getWaterLevelMax(), zInWorld);
        double icebergNoise = Math.min(Math.abs(noise), this.icebergNoise.sample((double)xInWorld * 0.1, (double)zInWorld * 0.1, false) * 15.0);
        if (icebergNoise > 1.8) {
            icebergHeight = icebergNoise * icebergNoise * 1.2;
            double icebergCutoff = Math.abs(this.icebergCutoffNoise.sample((double)xInWorld * 0.09765625, (double)zInWorld * 0.09765625, false));
            double maxHeight = Math.ceil(icebergCutoff * 40.0) + 14.0;
            if (icebergHeight > maxHeight) {
                icebergHeight = maxHeight;
            }
            if (temperature > 0.1f) {
                icebergHeight -= 2.0;
            }
            if (icebergHeight > 2.0) {
                icebergDepth = (double)seaLevel - icebergHeight - 7.0;
                icebergHeight += (double)seaLevel;
            } else {
                icebergHeight = 0.0;
            }
        }
        int dirtDepth = (int)(generatingChunk.getNoise(internalX, internalZ) / 3.0 + 3.0 + generatingChunk.random.nextDouble() * 0.25);
        int generatedSnow = 0;
        int snowHeight = 2 + random.nextInt(4);
        int snowStart = seaLevel + 18 + random.nextInt(10);
        int groundLayerDepth = -1;
        LocalMaterialData currentSurfaceBlock = null;
        boolean useWaterForSurface = false;
        boolean useIceForSurface = false;
        boolean useAirForSurface = false;
        boolean useLayerSurfaceBlockForSurface = true;
        boolean useBiomeStoneBlockForGround = false;
        boolean useLayerGroundBlockForGround = true;
        boolean useSandStoneForGround = false;
        boolean biomeGroundBlockIsSand = biomeConfig.getDefaultGroundBlock().isMaterial(LocalMaterials.SAND);
        boolean layerGroundBlockIsSand = layer != null && layer.groundBlock.isMaterial(LocalMaterials.SAND);
        LocalMaterialData blockOnPreviousPos = null;
        int topY = chunkBuffer.getHighestBlockForColumn(internalX, internalZ);
        for (int y = Math.max(topY, (int)icebergHeight + 1); y >= 0; --y) {
            if (generatingChunk.mustCreateBedrockAt(biomeConfig.isFlatBedrock(), biomeConfig.isBedrockDisabled(), biomeConfig.isCeilingBedrock(), y)) {
                chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getBedrockBlockReplaced(y));
                continue;
            }
            boolean setIceberg = false;
            if (chunkBuffer.getBlock(internalX, y, internalZ).isAir() && (double)y < icebergHeight && random.nextDouble() > 0.01) {
                chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getPackedIceBlockReplaced(y));
                setIceberg = true;
            } else if (chunkBuffer.getBlock(internalX, y, internalZ).isMaterial(biomeConfig.getWaterBlockReplaced(y)) && y > (int)icebergDepth && y < seaLevel && icebergDepth != 0.0 && random.nextDouble() > 0.15) {
                chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getPackedIceBlockReplaced(y));
                setIceberg = true;
            }
            if (chunkBuffer.getBlock(internalX, y, internalZ).isMaterial(biomeConfig.getPackedIceBlockReplaced(y)) && generatedSnow <= snowHeight && y > snowStart) {
                chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getSnowBlockReplaced(y));
                ++snowHeight;
                setIceberg = true;
            }
            if (setIceberg) continue;
            LocalMaterialData blockOnCurrentPos = chunkBuffer.getBlock(internalX, y, internalZ);
            if (blockOnCurrentPos.isEmptyOrAir()) {
                groundLayerDepth = -1;
            } else if (!blockOnCurrentPos.equals(biomeConfig.getWaterBlockReplaced(y))) {
                if (groundLayerDepth == -1) {
                    groundLayerDepth = dirtDepth;
                    if (dirtDepth <= 0 && !biomeConfig.isRemoveSurfaceStone()) {
                        useAirForSurface = true;
                        useIceForSurface = false;
                        useWaterForSurface = false;
                        useLayerSurfaceBlockForSurface = false;
                        useSandStoneForGround = false;
                        useBiomeStoneBlockForGround = true;
                        useLayerGroundBlockForGround = false;
                    } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                        useAirForSurface = false;
                        useIceForSurface = false;
                        useWaterForSurface = false;
                        useLayerSurfaceBlockForSurface = true;
                        useSandStoneForGround = false;
                        useBiomeStoneBlockForGround = false;
                        useLayerGroundBlockForGround = true;
                    }
                    if (y < seaLevel && y > biomeConfig.getWaterLevelMin()) {
                        boolean bIsAir = useAirForSurface;
                        if (!bIsAir && useLayerSurfaceBlockForSurface) {
                            bIsAir = (layer != null ? layer.getSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getSurfaceBlockReplaced(y)).isAir();
                        }
                        if (bIsAir) {
                            if (biome.getTemperatureAt(xInWorld, y, zInWorld) < 0.15f) {
                                useAirForSurface = false;
                                useIceForSurface = true;
                                useWaterForSurface = false;
                                useLayerSurfaceBlockForSurface = false;
                            } else {
                                useAirForSurface = false;
                                useIceForSurface = false;
                                useWaterForSurface = true;
                                useLayerSurfaceBlockForSurface = false;
                            }
                        }
                    }
                    if (y >= seaLevel - 1) {
                        if (useAirForSurface) {
                            currentSurfaceBlock = LocalMaterials.AIR;
                        } else if (useIceForSurface) {
                            currentSurfaceBlock = biomeConfig.getIceBlockReplaced(y);
                        } else if (useWaterForSurface) {
                            currentSurfaceBlock = biomeConfig.getWaterBlockReplaced(y);
                        } else if (useLayerSurfaceBlockForSurface) {
                            currentSurfaceBlock = layer != null ? layer.getSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getSurfaceBlockReplaced(y);
                        }
                        chunkBuffer.setBlock(internalX, y, internalZ, currentSurfaceBlock);
                    } else {
                        if (useBiomeStoneBlockForGround) {
                            blockOnPreviousPos = blockOnCurrentPos;
                            continue;
                        }
                        if (useLayerGroundBlockForGround) {
                            if (blockOnPreviousPos != null && blockOnPreviousPos.isLiquid()) {
                                chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getUnderWaterSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getUnderWaterSurfaceBlockReplaced(y));
                            } else {
                                chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getGroundBlockReplaced(y, biomeConfig) : biomeConfig.getGroundBlockReplaced(y));
                            }
                        }
                    }
                } else if (groundLayerDepth > 0) {
                    --groundLayerDepth;
                    if (useBiomeStoneBlockForGround) {
                        blockOnPreviousPos = blockOnCurrentPos;
                        continue;
                    }
                    if (useLayerGroundBlockForGround) {
                        if (useSandStoneForGround) {
                            chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getSandStoneBlockReplaced(y));
                        } else if (blockOnPreviousPos != null && blockOnPreviousPos.isLiquid()) {
                            chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getUnderWaterSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getUnderWaterSurfaceBlockReplaced(y));
                        } else {
                            chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getGroundBlockReplaced(y, biomeConfig) : biomeConfig.getGroundBlockReplaced(y));
                        }
                        if (groundLayerDepth == 0 && dirtDepth > 1 && (layerGroundBlockIsSand || layer == null && biomeGroundBlockIsSand)) {
                            groundLayerDepth = generatingChunk.random.nextInt(4) + Math.max(0, y - seaLevel);
                            useSandStoneForGround = true;
                        }
                    }
                }
            }
            blockOnPreviousPos = blockOnCurrentPos;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.layers.size() > 0) {
            for (MultipleLayersSurfaceGeneratorLayer groundLayer : this.layers) {
                stringBuilder.append(groundLayer.surfaceBlock);
                stringBuilder.append(',').append(' ');
                stringBuilder.append(groundLayer.underWaterSurfaceBlock);
                stringBuilder.append(',').append(' ');
                stringBuilder.append(groundLayer.groundBlock);
                stringBuilder.append(',').append(' ');
                stringBuilder.append(groundLayer.maxNoise);
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        }
        return "Iceberg " + stringBuilder.toString();
    }

    public static IcebergSurfaceGenerator getFor(String settingValue, IMaterialReader materialReader) throws InvalidConfigException {
        if (settingValue.toLowerCase().trim().startsWith("iceberg ")) {
            String[] parts = StringHelper.readCommaSeperatedString(settingValue.toLowerCase().trim().substring("iceberg ".length()));
            return new IcebergSurfaceGenerator(parts, materialReader);
        }
        if (settingValue.toLowerCase().trim().equals("iceberg")) {
            return new IcebergSurfaceGenerator(new String[0], materialReader);
        }
        return null;
    }
}

