/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.surface;

import com.pg85.otg.gen.surface.MultipleLayersSurfaceGeneratorLayer;
import com.pg85.otg.gen.surface.SurfaceGenerator;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ISurfaceGeneratorNoiseProvider;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.gen.GeneratingChunk;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;

public class SimpleSurfaceGenerator
implements SurfaceGenerator {
    @Override
    public LocalMaterialData getSurfaceBlockAtHeight(ISurfaceGeneratorNoiseProvider noiseProvider, IBiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return biomeConfig.getSurfaceBlockReplaced(yInWorld);
    }

    @Override
    public LocalMaterialData getGroundBlockAtHeight(ISurfaceGeneratorNoiseProvider noiseProvider, IBiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return biomeConfig.getGroundBlockReplaced(yInWorld);
    }

    @Override
    public void spawn(long worldSeed, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, IBiome biome, int xInWorld, int zInWorld) {
        this.spawnColumn(worldSeed, null, generatingChunk, chunkBuffer, biome, xInWorld, zInWorld);
    }

    protected void spawnColumn(long worldSeed, MultipleLayersSurfaceGeneratorLayer layer, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, IBiome biome, int xInWorld, int zInWorld) {
        int highestBlockInColumn;
        int internalX = xInWorld & 0xF;
        int internalZ = zInWorld & 0xF;
        IBiomeConfig biomeConfig = biome.getBiomeConfig();
        int biomeBlocksNoise = (int)(generatingChunk.getNoise(internalX, internalZ) / 3.0 + 3.0 + generatingChunk.random.nextDouble() * 0.25);
        if (biomeConfig.isCeilingBedrock()) {
            chunkBuffer.setBlock(internalX, generatingChunk.heightCap - 2, internalZ, biomeConfig.getBedrockBlockReplaced(generatingChunk.heightCap - 2));
        }
        int groundLayerDepth = -1;
        LocalMaterialData currentSurfaceBlock = null;
        boolean useWaterForSurface = false;
        boolean useIceForSurface = false;
        boolean useAirForSurface = false;
        boolean useLayerSurfaceBlockForSurface = true;
        boolean useBiomeStoneBlockForGround = false;
        boolean useLayerGroundBlockForGround = true;
        boolean useSandStoneForGround = false;
        boolean biomeGroundBlockIsSand = biomeConfig.getDefaultGroundBlock().isMaterial(LocalMaterials.SAND);
        boolean layerGroundBlockIsSand = layer != null && layer.groundBlock.isMaterial(LocalMaterials.SAND);
        int currentWaterLevel = generatingChunk.getWaterLevel(internalX, internalZ);
        LocalMaterialData blockOnPreviousPos = null;
        for (int y = highestBlockInColumn = chunkBuffer.getHighestBlockForColumn(internalX, internalZ); y >= 0; --y) {
            if (generatingChunk.mustCreateBedrockAt(biomeConfig.isFlatBedrock(), biomeConfig.isBedrockDisabled(), biomeConfig.isCeilingBedrock(), y)) {
                chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getBedrockBlockReplaced(y));
                continue;
            }
            LocalMaterialData blockOnCurrentPos = chunkBuffer.getBlock(internalX, y, internalZ);
            if (blockOnCurrentPos.isEmptyOrAir()) {
                groundLayerDepth = -1;
            } else if (!blockOnCurrentPos.equals(biomeConfig.getWaterBlockReplaced(y))) {
                if (groundLayerDepth == -1) {
                    groundLayerDepth = biomeBlocksNoise;
                    if (biomeBlocksNoise <= 0 && !biomeConfig.isRemoveSurfaceStone()) {
                        useAirForSurface = true;
                        useIceForSurface = false;
                        useWaterForSurface = false;
                        useLayerSurfaceBlockForSurface = false;
                        useSandStoneForGround = false;
                        useBiomeStoneBlockForGround = true;
                        useLayerGroundBlockForGround = false;
                    } else if (y >= currentWaterLevel - 4 && y <= currentWaterLevel + 1) {
                        useAirForSurface = false;
                        useIceForSurface = false;
                        useWaterForSurface = false;
                        useLayerSurfaceBlockForSurface = true;
                        useSandStoneForGround = false;
                        useBiomeStoneBlockForGround = false;
                        useLayerGroundBlockForGround = true;
                    }
                    if (y < currentWaterLevel && y > biomeConfig.getWaterLevelMin()) {
                        boolean bIsAir = useAirForSurface;
                        if (!bIsAir && useLayerSurfaceBlockForSurface) {
                            bIsAir = (layer != null ? layer.getSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getSurfaceBlockReplaced(y)).isAir();
                        }
                        if (bIsAir) {
                            if (biome.getTemperatureAt(xInWorld, y, zInWorld) < 0.15f) {
                                useAirForSurface = false;
                                useIceForSurface = true;
                                useWaterForSurface = false;
                                useLayerSurfaceBlockForSurface = false;
                            } else {
                                useAirForSurface = false;
                                useIceForSurface = false;
                                useWaterForSurface = true;
                                useLayerSurfaceBlockForSurface = false;
                            }
                        }
                    }
                    if (y >= currentWaterLevel - 1) {
                        if (useAirForSurface) {
                            currentSurfaceBlock = LocalMaterials.AIR;
                        } else if (useIceForSurface) {
                            currentSurfaceBlock = biomeConfig.getIceBlockReplaced(y);
                        } else if (useWaterForSurface) {
                            currentSurfaceBlock = biomeConfig.getWaterBlockReplaced(y);
                        } else if (useLayerSurfaceBlockForSurface) {
                            currentSurfaceBlock = layer != null ? layer.getSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getSurfaceBlockReplaced(y);
                        }
                        chunkBuffer.setBlock(internalX, y, internalZ, currentSurfaceBlock);
                    } else {
                        if (useBiomeStoneBlockForGround) {
                            blockOnPreviousPos = blockOnCurrentPos;
                            continue;
                        }
                        if (useLayerGroundBlockForGround) {
                            if (blockOnPreviousPos != null && blockOnPreviousPos.isLiquid()) {
                                chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getUnderWaterSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getUnderWaterSurfaceBlockReplaced(y));
                            } else {
                                chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getGroundBlockReplaced(y, biomeConfig) : biomeConfig.getGroundBlockReplaced(y));
                            }
                        }
                    }
                } else if (groundLayerDepth > 0) {
                    --groundLayerDepth;
                    if (useBiomeStoneBlockForGround) {
                        blockOnPreviousPos = blockOnCurrentPos;
                        continue;
                    }
                    if (useLayerGroundBlockForGround) {
                        if (useSandStoneForGround) {
                            chunkBuffer.setBlock(internalX, y, internalZ, biomeConfig.getSandStoneBlockReplaced(y));
                        } else if (blockOnPreviousPos != null && blockOnPreviousPos.isLiquid()) {
                            chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getUnderWaterSurfaceBlockReplaced(y, biomeConfig) : biomeConfig.getUnderWaterSurfaceBlockReplaced(y));
                        } else {
                            chunkBuffer.setBlock(internalX, y, internalZ, layer != null ? layer.getGroundBlockReplaced(y, biomeConfig) : biomeConfig.getGroundBlockReplaced(y));
                        }
                        if (groundLayerDepth == 0 && biomeBlocksNoise > 1 && (layerGroundBlockIsSand || layer == null && biomeGroundBlockIsSand)) {
                            groundLayerDepth = generatingChunk.random.nextInt(4) + Math.max(0, y - currentWaterLevel);
                            useSandStoneForGround = true;
                        }
                    }
                }
            }
            blockOnPreviousPos = blockOnCurrentPos;
        }
    }

    @Override
    public String toString() {
        return "";
    }
}

