/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.gen.surface;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.gen.surface.IcebergSurfaceGenerator;
import com.pg85.otg.gen.surface.MesaSurfaceGenerator;
import com.pg85.otg.gen.surface.MultipleLayersSurfaceGenerator;
import com.pg85.otg.gen.surface.SimpleSurfaceGenerator;
import com.pg85.otg.gen.surface.SurfaceGenerator;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;

public class SurfaceGeneratorSetting
extends Setting<SurfaceGenerator> {
    public static final Setting<SurfaceGenerator> SURFACE_AND_GROUND_CONTROL = SurfaceGeneratorSetting.surfaceGeneratorSetting("SurfaceAndGroundControl");

    private SurfaceGeneratorSetting(String name) {
        super(name);
    }

    @Override
    public SurfaceGenerator getDefaultValue(IMaterialReader materialReader) {
        return new SimpleSurfaceGenerator();
    }

    @Override
    public SurfaceGenerator read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        if (string.length() > 0) {
            MesaSurfaceGenerator mesa = MesaSurfaceGenerator.getFor(string);
            if (mesa != null) {
                return mesa;
            }
            IcebergSurfaceGenerator iceberg = IcebergSurfaceGenerator.getFor(string, materialReader);
            if (iceberg != null) {
                return iceberg;
            }
            String[] parts = StringHelper.readCommaSeperatedString(string);
            return new MultipleLayersSurfaceGenerator(parts, materialReader);
        }
        return new SimpleSurfaceGenerator();
    }

    private static final Setting<SurfaceGenerator> surfaceGeneratorSetting(String name) {
        return new SurfaceGeneratorSetting(name);
    }
}

