/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.presets;

import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.config.biome.BiomeConfigFinder;
import com.pg85.otg.config.io.FileSettingsReader;
import com.pg85.otg.config.io.FileSettingsWriter;
import com.pg85.otg.config.io.IConfigFunctionProvider;
import com.pg85.otg.config.io.SettingsMap;
import com.pg85.otg.config.standard.BiomeStandardValues;
import com.pg85.otg.config.world.WorldConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.BiomeRegistryNames;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class LocalPresetLoader {
    private static final int MAX_INHERITANCE_DEPTH = 15;
    protected final Object materialReaderLock = new Object();
    protected final File presetsDir;
    protected final HashMap<String, Preset> presets = new HashMap();
    protected final HashMap<String, String> aliasMap = new HashMap();
    protected HashMap<String, IMaterialReader> materialReaderByPresetFolderName = new HashMap();

    public LocalPresetLoader(Path otgRootFolder) {
        this.presetsDir = Paths.get(otgRootFolder.toString(), File.separator + "Presets").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMaterialReader getMaterialReader(String presetFolderName) {
        IMaterialReader materialReader;
        Object object = this.materialReaderLock;
        synchronized (object) {
            materialReader = this.materialReaderByPresetFolderName.get(presetFolderName);
            if (materialReader == null) {
                materialReader = this.createMaterialReader();
                this.materialReaderByPresetFolderName.put(presetFolderName, materialReader);
            }
        }
        return materialReader;
    }

    protected abstract IMaterialReader createMaterialReader();

    public abstract void registerBiomes();

    protected abstract void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub var1, String var2);

    public Preset getPresetByShortNameOrFolderName(String name) {
        if (this.aliasMap.containsKey(name)) {
            return this.presets.get(this.aliasMap.get(name));
        }
        return this.presets.get(name);
    }

    public Preset getPresetByFolderName(String name) {
        return this.presets.get(name);
    }

    public ArrayList<Preset> getAllPresets() {
        return new ArrayList<Preset>(this.presets.values());
    }

    public Set<String> getAllPresetFolderNames() {
        return this.presets.keySet();
    }

    public String getDefaultPresetFolderName() {
        return this.presets.keySet().size() == 0 ? "Default" : (this.presets.keySet().contains("Default") ? "Default" : (String)this.presets.keySet().toArray()[0]);
    }

    public void loadPresetsFromDisk(IConfigFunctionProvider biomeResourcesManager, ILogger logger) {
        if (this.presetsDir.exists() && this.presetsDir.isDirectory()) {
            block0: for (File presetDir : this.presetsDir.listFiles()) {
                if (!presetDir.isDirectory()) continue;
                for (File file : presetDir.listFiles()) {
                    if (!file.getName().equals("WorldConfig.ini")) continue;
                    Preset preset = this.loadPreset(presetDir.toPath(), biomeResourcesManager, logger);
                    this.presets.put(preset.getFolderName(), preset);
                    this.aliasMap.put(preset.getShortPresetName(), preset.getFolderName());
                    continue block0;
                }
            }
        }
    }

    protected Preset loadPreset(Path presetDir, IConfigFunctionProvider biomeResourcesManager, ILogger logger) {
        File worldConfigFile = new File(presetDir.toString(), "WorldConfig.ini");
        File biomesDirectory = new File(presetDir.toString(), "Biomes");
        if (!biomesDirectory.exists()) {
            biomesDirectory = new File(presetDir.toString(), "WorldBiomes");
        }
        String presetFolderName = presetDir.toFile().getName();
        SettingsMap worldConfigSettings = FileSettingsReader.read(presetFolderName, worldConfigFile, logger);
        WorldConfig worldConfig = new WorldConfig(presetDir, worldConfigSettings, this.addBiomesFromDirRecursive(biomesDirectory), biomeResourcesManager, logger, this.getMaterialReader(presetFolderName), presetFolderName);
        FileSettingsWriter.writeToFile(worldConfig.getSettingsAsMap(), worldConfigFile, worldConfig.getSettingsMode(), logger);
        ArrayList<BiomeConfig> biomeConfigs = this.loadBiomeConfigs(worldConfig.getShortPresetName(), worldConfig.getMajorVersion(), presetDir, biomesDirectory.toPath(), worldConfig, biomeResourcesManager, logger, this.getMaterialReader(presetFolderName));
        return new Preset(presetDir, worldConfig.getShortPresetName(), worldConfig, biomeConfigs);
    }

    private ArrayList<String> addBiomesFromDirRecursive(File biomesDirectory) {
        ArrayList<String> biomes = new ArrayList<String>();
        if (biomesDirectory.exists()) {
            for (File biomeConfig : biomesDirectory.listFiles()) {
                if (biomeConfig.isFile() && biomeConfig.getName().endsWith(".bc")) {
                    biomes.add(biomeConfig.getName().replace(".bc", ""));
                    continue;
                }
                if (!biomeConfig.isDirectory()) continue;
                biomes.addAll(this.addBiomesFromDirRecursive(biomeConfig));
            }
        }
        return biomes;
    }

    private ArrayList<BiomeConfig> loadBiomeConfigs(String presetShortName, int presetMajorVersion, Path presetDir, Path presetBiomesDir, IWorldConfig worldConfig, IConfigFunctionProvider biomeResourcesManager, ILogger logger, IMaterialReader materialReader) {
        ArrayList<Path> biomeDirs = new ArrayList<Path>(2);
        biomeDirs.add(presetBiomesDir);
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder();
        Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs = biomeConfigFinder.findBiomes(worldConfig.getWorldBiomes(), worldConfig.getWorldHeightScale(), biomeDirs, logger, materialReader);
        ArrayList<BiomeConfig> biomeConfigs = this.readAndWriteSettings(worldConfig, biomeConfigStubs, presetDir, presetShortName, presetMajorVersion, true, biomeResourcesManager, logger, materialReader);
        this.processSettings(worldConfig, biomeConfigs);
        if (logger.getLogCategoryEnabled(LogCategory.CONFIGS) && logger.canLogForPreset(presetDir.getFileName().toString())) {
            logger.log(LogLevel.INFO, LogCategory.CONFIGS, MessageFormat.format("{0} biomes Loaded", biomeConfigs.size()));
            logger.log(LogLevel.INFO, LogCategory.CONFIGS, biomeConfigs.stream().map(item -> item.getName()).collect(Collectors.joining(", ")));
        }
        return biomeConfigs;
    }

    private ArrayList<BiomeConfig> readAndWriteSettings(IWorldConfig worldConfig, Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, Path presetDir, String presetShortName, int presetMajorVersion, boolean write, IConfigFunctionProvider biomeResourcesManager, ILogger logger, IMaterialReader materialReader) {
        ArrayList<BiomeConfig> biomeConfigs = new ArrayList<BiomeConfig>();
        for (BiomeConfigFinder.BiomeConfigStub biomeConfigStub : biomeConfigStubs.values()) {
            this.processMobInheritance(biomeConfigStubs, biomeConfigStub, 0, logger);
            BiomeConfig biomeConfig = new BiomeConfig(biomeConfigStub.getBiomeName(), biomeConfigStub, presetDir, biomeConfigStub.getSettings(), worldConfig, presetShortName, presetMajorVersion, biomeResourcesManager, logger, materialReader);
            biomeConfigs.add(biomeConfig);
            if (!write) continue;
            Path writeFile = biomeConfigStub.getPath();
            FileSettingsWriter.writeToFile(biomeConfig.getSettingsAsMap(), writeFile.toFile(), worldConfig.getSettingsMode(), logger);
        }
        return biomeConfigs;
    }

    private void processSettings(IWorldConfig worldConfig, ArrayList<BiomeConfig> biomeConfigs) {
        for (BiomeConfig biomeConfig : biomeConfigs) {
            if (!worldConfig.getBiomeConfigsHaveReplacement()) {
                worldConfig.setBiomeConfigsHaveReplacement(biomeConfig.hasReplaceBlocksSettings());
            }
            if (worldConfig.getMaxSmoothRadius() < biomeConfig.getSmoothRadius()) {
                worldConfig.setMaxSmoothRadius(biomeConfig.getSmoothRadius());
            }
            if (worldConfig.getMaxSmoothRadius() >= biomeConfig.getCHCSmoothRadius()) continue;
            worldConfig.setMaxSmoothRadius(biomeConfig.getCHCSmoothRadius());
        }
    }

    private void processMobInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth, ILogger logger) {
        if (biomeConfigStub.inheritMobsBiomeNameProcessed) {
            return;
        }
        String stubInheritMobsBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.INHERIT_MOBS_BIOME_NAME, BiomeStandardValues.INHERIT_MOBS_BIOME_NAME.getDefaultValue(), logger, null);
        if (stubInheritMobsBiomeName != null && stubInheritMobsBiomeName.length() > 0) {
            String[] inheritMobsBiomeNames;
            for (String inheritMobsBiomeName : inheritMobsBiomeNames = stubInheritMobsBiomeName.split(",")) {
                if (inheritMobsBiomeName.isEmpty()) continue;
                BiomeConfigFinder.BiomeConfigStub inheritMobsBiomeConfig = biomeConfigStubs.get(inheritMobsBiomeName);
                if (inheritMobsBiomeConfig == null || inheritMobsBiomeConfig == biomeConfigStub) {
                    String vanillaBiomeName = BiomeRegistryNames.getRegistryNameForDefaultBiome(inheritMobsBiomeName);
                    if (vanillaBiomeName != null) {
                        inheritMobsBiomeConfig = null;
                        inheritMobsBiomeName = vanillaBiomeName;
                    } else if (inheritMobsBiomeConfig == biomeConfigStub) {
                        if (!logger.getLogCategoryEnabled(LogCategory.MOBS)) continue;
                        logger.log(LogLevel.ERROR, LogCategory.MOBS, MessageFormat.format("The biome {0} tried to inherit mobs from itself.", biomeConfigStub.getBiomeName()));
                        continue;
                    }
                }
                if (currentDepth > 15 && logger.getLogCategoryEnabled(LogCategory.MOBS)) {
                    logger.log(LogLevel.ERROR, LogCategory.MOBS, MessageFormat.format("The biome {0} cannot inherit mobs from biome {1} - too many configs processed already! Cyclical inheritance?", biomeConfigStub.getPath().toFile().getName(), inheritMobsBiomeConfig.getPath().toFile().getName()));
                }
                if (inheritMobsBiomeConfig != null) {
                    if (!inheritMobsBiomeConfig.inheritMobsBiomeNameProcessed) {
                        this.processMobInheritance(biomeConfigStubs, inheritMobsBiomeConfig, currentDepth + 1, logger);
                    }
                    biomeConfigStub.mergeMobs(inheritMobsBiomeConfig);
                    continue;
                }
                this.mergeVanillaBiomeMobSpawnSettings(biomeConfigStub, inheritMobsBiomeName);
            }
            biomeConfigStub.inheritMobsBiomeNameProcessed = true;
        }
    }
}

