/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.presets;

import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.config.world.WorldConfig;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;

public class Preset {
    private final Path presetFolder;
    private String presetFolderName;
    private String shortPresetName;
    private WorldConfig worldConfig;
    private HashMap<String, IBiomeConfig> biomeConfigs = new HashMap();
    private int majorVersion;
    private String author;
    private String description;

    public Preset(Path presetFolder, String shortPresetName, WorldConfig worldConfig, ArrayList<BiomeConfig> biomeConfigs) {
        this.presetFolder = presetFolder;
        this.presetFolderName = presetFolder.toFile().getName();
        this.shortPresetName = shortPresetName;
        this.worldConfig = worldConfig;
        this.author = worldConfig.getAuthor();
        this.description = worldConfig.getDescription();
        this.majorVersion = worldConfig.getMajorVersion();
        for (BiomeConfig biomeConfig : biomeConfigs) {
            this.biomeConfigs.put(biomeConfig.getName(), biomeConfig);
        }
    }

    public void update(Preset preset) {
        this.worldConfig = preset.worldConfig;
        this.biomeConfigs = preset.biomeConfigs;
        this.author = preset.author;
        this.description = preset.description;
        this.majorVersion = preset.majorVersion;
    }

    public Path getPresetFolder() {
        return this.presetFolder;
    }

    public String getFolderName() {
        return this.presetFolderName;
    }

    public String getShortPresetName() {
        return this.shortPresetName;
    }

    public IWorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    public IBiomeConfig getBiomeConfig(String biomeName) {
        return this.biomeConfigs.get(biomeName);
    }

    public ArrayList<IBiomeConfig> getAllBiomeConfigs() {
        return new ArrayList<IBiomeConfig>(this.biomeConfigs.values());
    }

    public ArrayList<String> getAllBiomeNames() {
        return new ArrayList<String>(this.biomeConfigs.keySet());
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }
}

