/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot;

import com.pg85.otg.OTG;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.SpigotEngine;
import com.pg85.otg.spigot.biome.OTGBiomeProvider;
import com.pg85.otg.spigot.commands.OTGCommandExecutor;
import com.pg85.otg.spigot.events.OTGHandler;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.spigot.gen.OTGSpigotChunkGen;
import com.pg85.otg.spigot.networking.NetworkingListener;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.ChunkGenerator;
import net.minecraft.server.v1_16_R3.ChunkProviderServer;
import net.minecraft.server.v1_16_R3.GeneratorSettingBase;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.IRegistryWritable;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.generator.CustomChunkGenerator;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class OTGPlugin
extends JavaPlugin
implements Listener {
    private static final ReentrantLock initLock = new ReentrantLock();
    private static final HashMap<String, String> worlds = new HashMap();
    private static final HashSet<String> processedWorlds = new HashSet();
    private OTGHandler handler;
    private static Field field;

    public void onDisable() {
    }

    public void onEnable() {
        IRegistry.a((IRegistry)IRegistry.BIOME_SOURCE, (MinecraftKey)new MinecraftKey("otg", "default"), OTGBiomeProvider.CODEC);
        IRegistry.a((IRegistry)IRegistry.CHUNK_GENERATOR, (MinecraftKey)new MinecraftKey("otg", "default"), OTGNoiseChunkGenerator.CODEC);
        OTG.startEngine(new SpigotEngine(this));
        Bukkit.getPluginCommand((String)"OTG").setExecutor((CommandExecutor)new OTGCommandExecutor());
        OTG.getEngine().getPresetLoader().registerBiomes();
        IRegistryWritable biome_registry = ((CraftServer)Bukkit.getServer()).getServer().customRegistry.b(IRegistry.ay);
        int i = 0;
        if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "-----------------");
            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Registered biomes:");
            for (BiomeBase biomeBase : biome_registry) {
                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, i++ + ": " + biomeBase.toString());
            }
            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "-----------------");
        }
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.handler = new OTGHandler(this);
        Bukkit.getPluginManager().registerEvents((Listener)new NetworkingListener(this), (Plugin)this);
    }

    public org.bukkit.generator.ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        Preset preset;
        if (id == null || id.equals("")) {
            id = "Default";
        }
        if ((preset = OTG.getEngine().getPresetLoader().getPresetByShortNameOrFolderName(id)) == null) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Could not find preset '" + id + "', did you install it correctly?");
            return null;
        }
        worlds.put(worldName, id);
        return new OTGSpigotChunkGen(preset);
    }

    @EventHandler
    public void onWorldEnable(WorldInitEvent event) {
        if (worlds.containsKey(event.getWorld().getName())) {
            OTGPlugin.injectInternalGenerator(event.getWorld());
        }
    }

    public static void injectInternalGenerator(World world) {
        initLock.lock();
        if (processedWorlds.contains(world.getName())) {
            return;
        }
        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Taking over world " + world.getName());
        WorldServer serverWorld = ((CraftWorld)world).getHandle();
        ChunkGenerator generator = serverWorld.getChunkProvider().getChunkGenerator();
        if (!(generator instanceof CustomChunkGenerator)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Mission failed, we'll get them next time");
            return;
        }
        if (!(world.getGenerator() instanceof OTGSpigotChunkGen)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "World generator was not an OTG generator, cannot take over, something has gone wrong");
            return;
        }
        OTGSpigotChunkGen OTGGen = (OTGSpigotChunkGen)world.getGenerator();
        OTGNoiseChunkGenerator OTGDelegate = OTGGen.generator == null ? new OTGNoiseChunkGenerator(OTGGen.getPreset().getFolderName(), new OTGBiomeProvider(OTGGen.getPreset().getFolderName(), world.getSeed(), false, false, (IRegistry<BiomeBase>)((CraftServer)Bukkit.getServer()).getServer().customRegistry.b(IRegistry.ay)), world.getSeed(), GeneratorSettingBase::i) : OTGGen.generator;
        try {
            Field finalGenerator = ChunkProviderServer.class.getDeclaredField("chunkGenerator");
            finalGenerator.setAccessible(true);
            finalGenerator.set(serverWorld.getChunkProvider(), (Object)OTGDelegate);
            Field pcmGen = PlayerChunkMap.class.getDeclaredField("chunkGenerator");
            pcmGen.setAccessible(true);
            pcmGen.set(serverWorld.getChunkProvider().playerChunkMap, (Object)OTGDelegate);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
        if (OTGGen.generator == null) {
            OTGGen.generator = OTGDelegate;
        }
        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Success!");
        processedWorlds.add(world.getName());
        initLock.unlock();
    }

    static {
        try {
            field = CustomChunkGenerator.class.getDeclaredField("delegate");
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }
}

