/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.gen.biome.layers.BiomeLayers;
import com.pg85.otg.gen.biome.layers.util.CachingLayerSampler;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILayerSource;
import com.pg85.otg.spigot.presets.SpigotPresetLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.Biomes;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.RegistryLookupCodec;
import net.minecraft.server.v1_16_R3.ResourceKey;
import net.minecraft.server.v1_16_R3.WorldChunkManager;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class OTGBiomeProvider
extends WorldChunkManager
implements ILayerSource {
    public static final Codec<OTGBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("preset_name").stable().forGetter(provider -> provider.presetFolderName), (App)Codec.LONG.fieldOf("seed").stable().forGetter(provider -> provider.seed), (App)Codec.BOOL.optionalFieldOf("legacy_biome_init_layer", (Object)Boolean.FALSE, Lifecycle.stable()).forGetter(provider -> provider.legacyBiomeInitLayer), (App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(provider -> provider.largeBiomes), (App)RegistryLookupCodec.a((ResourceKey)IRegistry.ay).forGetter(provider -> provider.registry)).apply((Applicative)instance, instance.stable(OTGBiomeProvider::new)));
    private final long seed;
    private final boolean legacyBiomeInitLayer;
    private final boolean largeBiomes;
    private final IRegistry<BiomeBase> registry;
    private final ThreadLocal<CachingLayerSampler> layer;
    private final Int2ObjectMap<ResourceKey<BiomeBase>> keyLookup;
    private final String presetFolderName;

    public OTGBiomeProvider(String presetFolderName, long seed, boolean legacyBiomeInitLayer, boolean largeBiomes, IRegistry<BiomeBase> registry) {
        super(OTGBiomeProvider.getAllBiomesByPreset(presetFolderName, registry));
        this.presetFolderName = presetFolderName;
        this.seed = seed;
        this.legacyBiomeInitLayer = legacyBiomeInitLayer;
        this.largeBiomes = largeBiomes;
        this.registry = registry;
        this.layer = ThreadLocal.withInitial(() -> BiomeLayers.create(seed, ((SpigotPresetLoader)OTG.getEngine().getPresetLoader()).getPresetGenerationData().get(presetFolderName), OTG.getEngine().getLogger()));
        this.keyLookup = new Int2ObjectOpenHashMap();
        this.keyLookup.defaultReturnValue((Object)Biomes.OCEAN);
        IBiome[] biomeLookup = ((SpigotPresetLoader)OTG.getEngine().getPresetLoader()).getGlobalIdMapping(presetFolderName);
        if (biomeLookup == null) {
            throw new RuntimeException("No OTG preset found with name \"" + presetFolderName + "\". Install the correct preset or update your server.properties.");
        }
        for (int biomeId = 0; biomeId < biomeLookup.length; ++biomeId) {
            IBiomeConfig config = biomeLookup[biomeId].getBiomeConfig();
            ResourceKey key = ResourceKey.a((ResourceKey)IRegistry.ay, (MinecraftKey)new MinecraftKey(config.getRegistryKey().toResourceLocationString()));
            this.keyLookup.put(biomeId, (Object)key);
        }
    }

    private static Stream<Supplier<BiomeBase>> getAllBiomesByPreset(String presetFolderName, IRegistry<BiomeBase> registry) {
        List<ResourceKey<BiomeBase>> biomesForPreset = ((SpigotPresetLoader)OTG.getEngine().getPresetLoader()).getBiomeRegistryKeys(presetFolderName);
        if (biomesForPreset == null) {
            ((SpigotPresetLoader)OTG.getEngine().getPresetLoader()).getBiomeRegistryKeys(OTG.getEngine().getPresetLoader().getDefaultPresetFolderName());
        }
        if (biomesForPreset == null) {
            biomesForPreset = new ArrayList<ResourceKey<BiomeBase>>();
        }
        return biomesForPreset.stream().map(p_242638_1_ -> () -> (BiomeBase)registry.d(p_242638_1_));
    }

    protected Codec<? extends WorldChunkManager> a() {
        return CODEC;
    }

    public BiomeBase getBiome(int biomeX, int biomeY, int biomeZ) {
        return (BiomeBase)this.registry.a((ResourceKey)this.keyLookup.get(this.layer.get().sample(biomeX, biomeZ)));
    }

    @Override
    public CachingLayerSampler getSampler() {
        return this.layer.get();
    }
}

