/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.biome;

import com.pg85.otg.OTG;
import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.config.standard.BiomeStandardValues;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.gen.resource.RegistryResource;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.biome.OTGBiomeResourceLocation;
import com.pg85.otg.util.biome.WeightedMobSpawnGroup;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeFog;
import net.minecraft.server.v1_16_R3.BiomeParticles;
import net.minecraft.server.v1_16_R3.BiomeSettingsGeneration;
import net.minecraft.server.v1_16_R3.BiomeSettingsMobs;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.CaveSound;
import net.minecraft.server.v1_16_R3.CaveSoundSettings;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumCreatureType;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.Music;
import net.minecraft.server.v1_16_R3.ParticleParam;
import net.minecraft.server.v1_16_R3.RegistryGeneration;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.StructureFeature;
import net.minecraft.server.v1_16_R3.StructureFeatures;
import net.minecraft.server.v1_16_R3.StructureGenerator;
import net.minecraft.server.v1_16_R3.WorldGenFeatureBastionPieces;
import net.minecraft.server.v1_16_R3.WorldGenFeatureConfiguration;
import net.minecraft.server.v1_16_R3.WorldGenFeatureConfigurationChance;
import net.minecraft.server.v1_16_R3.WorldGenFeatureConfigured;
import net.minecraft.server.v1_16_R3.WorldGenFeatureDesertVillage;
import net.minecraft.server.v1_16_R3.WorldGenFeatureOceanRuin;
import net.minecraft.server.v1_16_R3.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.server.v1_16_R3.WorldGenFeaturePillagerOutpostPieces;
import net.minecraft.server.v1_16_R3.WorldGenFeatureVillageConfiguration;
import net.minecraft.server.v1_16_R3.WorldGenFeatureVillagePlain;
import net.minecraft.server.v1_16_R3.WorldGenFeatureVillageSavanna;
import net.minecraft.server.v1_16_R3.WorldGenFeatureVillageSnowy;
import net.minecraft.server.v1_16_R3.WorldGenFeatureVillageTaiga;
import net.minecraft.server.v1_16_R3.WorldGenMineshaft;
import net.minecraft.server.v1_16_R3.WorldGenMineshaftConfiguration;
import net.minecraft.server.v1_16_R3.WorldGenStage;
import net.minecraft.server.v1_16_R3.WorldGenSurfaceComposites;

public class SpigotBiome
implements IBiome {
    private final BiomeBase biomeBase;
    private final IBiomeConfig biomeConfig;

    public SpigotBiome(BiomeBase biomeBase, IBiomeConfig biomeConfig) {
        this.biomeBase = biomeBase;
        this.biomeConfig = biomeConfig;
    }

    public BiomeBase getBiomeBase() {
        return this.biomeBase;
    }

    @Override
    public IBiomeConfig getBiomeConfig() {
        return this.biomeConfig;
    }

    public static BiomeBase createOTGBiome(boolean isOceanBiome, IWorldConfig worldConfig, IBiomeConfig biomeConfig) {
        BiomeBase.Geography category;
        BiomeSettingsGeneration.a biomeGenerationSettingsBuilder = new BiomeSettingsGeneration.a();
        BiomeSettingsMobs.a mobSpawnInfoBuilder = SpigotBiome.createMobSpawnInfo(biomeConfig);
        biomeGenerationSettingsBuilder.a(WorldGenSurfaceComposites.j);
        for (ConfigFunction res : ((BiomeConfig)biomeConfig).getResourceQueue()) {
            if (!(res instanceof RegistryResource)) continue;
            RegistryResource registryResource = (RegistryResource)res;
            WorldGenStage.Decoration stage = WorldGenStage.Decoration.valueOf((String)registryResource.getDecorationStage());
            WorldGenFeatureConfigured registry = (WorldGenFeatureConfigured)RegistryGeneration.e.get(new MinecraftKey(registryResource.getFeatureKey()));
            biomeGenerationSettingsBuilder.a(stage, registry);
        }
        SpigotBiome.addVanillaStructures(biomeGenerationSettingsBuilder, worldConfig, biomeConfig);
        float safeTemperature = biomeConfig.getBiomeTemperature();
        if ((double)safeTemperature >= 0.1 && (double)safeTemperature <= 0.2) {
            safeTemperature = (double)safeTemperature >= 1.5 ? 0.2f : 0.1f;
        }
        BiomeFog.a biomeAmbienceBuilder = new BiomeFog.a().a(biomeConfig.getFogColor() != BiomeStandardValues.FOG_COLOR.getDefaultValue(null).intValue() ? biomeConfig.getFogColor() : worldConfig.getFogColor()).b(biomeConfig.getWaterColor() != BiomeStandardValues.WATER_COLOR.getDefaultValue().intValue() ? biomeConfig.getWaterColor() : 4159204).c(biomeConfig.getWaterFogColor() != BiomeStandardValues.WATER_FOG_COLOR.getDefaultValue().intValue() ? biomeConfig.getWaterFogColor() : 329011).d(biomeConfig.getSkyColor() != BiomeStandardValues.SKY_COLOR.getDefaultValue().intValue() ? biomeConfig.getSkyColor() : SpigotBiome.getSkyColorForTemp(safeTemperature));
        Optional particleType = IRegistry.PARTICLE_TYPE.getOptional(new MinecraftKey(biomeConfig.getParticleType()));
        if (particleType.isPresent() && particleType.get() instanceof ParticleParam) {
            biomeAmbienceBuilder.a(new BiomeParticles((ParticleParam)particleType.get(), biomeConfig.getParticleProbability()));
        }
        Optional music = IRegistry.SOUND_EVENT.getOptional(new MinecraftKey(biomeConfig.getMusic()));
        music.ifPresent(soundEffect -> biomeAmbienceBuilder.a(new Music(soundEffect, biomeConfig.getMusicMinDelay(), biomeConfig.getMusicMaxDelay(), biomeConfig.isReplaceCurrentMusic())));
        Optional ambientSound = IRegistry.SOUND_EVENT.getOptional(new MinecraftKey(biomeConfig.getAmbientSound()));
        ambientSound.ifPresent(soundEffect -> biomeAmbienceBuilder.a((SoundEffect)ambientSound.get()));
        Optional moodSound = IRegistry.SOUND_EVENT.getOptional(new MinecraftKey(biomeConfig.getMoodSound()));
        moodSound.ifPresent(soundEffect -> biomeAmbienceBuilder.a(new CaveSoundSettings((SoundEffect)moodSound.get(), biomeConfig.getMoodSoundDelay(), biomeConfig.getMoodSearchRange(), biomeConfig.getMoodOffset())));
        Optional additionsSound = IRegistry.SOUND_EVENT.getOptional(new MinecraftKey(biomeConfig.getAdditionsSound()));
        additionsSound.ifPresent(soundEffect -> biomeAmbienceBuilder.a(new CaveSound((SoundEffect)additionsSound.get(), biomeConfig.getAdditionsTickChance())));
        if (biomeConfig.getFoliageColor() != 0xFFFFFF) {
            biomeAmbienceBuilder.e(biomeConfig.getFoliageColor());
        }
        if (biomeConfig.getGrassColor() != 0xFFFFFF) {
            biomeAmbienceBuilder.f(biomeConfig.getGrassColor());
        }
        switch (biomeConfig.getGrassColorModifier()) {
            case Swamp: {
                biomeAmbienceBuilder.a(BiomeFog.GrassColor.SWAMP);
                break;
            }
            case DarkForest: {
                biomeAmbienceBuilder.a(BiomeFog.GrassColor.DARK_FOREST);
                break;
            }
        }
        BiomeBase.a builder = new BiomeBase.a().a((double)biomeConfig.getBiomeWetness() <= 1.0E-4 ? BiomeBase.Precipitation.NONE : (biomeConfig.getBiomeTemperature() > 0.15f ? BiomeBase.Precipitation.RAIN : BiomeBase.Precipitation.SNOW)).a(biomeConfig.getBiomeHeight()).b(biomeConfig.getBiomeVolatility()).c(safeTemperature).d(biomeConfig.getBiomeWetness()).a(biomeAmbienceBuilder.a()).a(mobSpawnInfoBuilder.b()).a(biomeGenerationSettingsBuilder.a());
        if (biomeConfig.useFrozenOceanTemperature()) {
            builder.a(BiomeBase.TemperatureModifier.FROZEN);
        }
        builder.a((category = BiomeBase.Geography.a((String)biomeConfig.getBiomeCategory())) != null ? category : (isOceanBiome ? BiomeBase.Geography.OCEAN : BiomeBase.Geography.NONE));
        if (category == null && OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Could not parse biome category " + biomeConfig.getBiomeCategory());
        }
        return builder.a();
    }

    private static int getSkyColorForTemp(float safeTemperature) {
        float lvt_1_1_ = safeTemperature / 3.0f;
        lvt_1_1_ = MathHelper.a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.f((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    private static void addVanillaStructures(BiomeSettingsGeneration.a biomeGenerationSettingsBuilder, IWorldConfig worldConfig, IBiomeConfig biomeConfig) {
        if (worldConfig.getVillagesEnabled() && biomeConfig.getVillageType() != SettingsEnums.VillageType.disabled) {
            int villageSize = biomeConfig.getVillageSize();
            SettingsEnums.VillageType villageType = biomeConfig.getVillageType();
            StructureFeature customVillage = SpigotBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("village").toResourceLocationString(), StructureGenerator.VILLAGE.a((WorldGenFeatureConfiguration)new WorldGenFeatureVillageConfiguration(() -> {
                switch (villageType) {
                    case sandstone: {
                        return WorldGenFeatureDesertVillage.a;
                    }
                    case savanna: {
                        return WorldGenFeatureVillageSavanna.a;
                    }
                    case taiga: {
                        return WorldGenFeatureVillageTaiga.a;
                    }
                    case wood: {
                        return WorldGenFeatureVillagePlain.a;
                    }
                    case snowy: {
                        return WorldGenFeatureVillageSnowy.a;
                    }
                }
                return WorldGenFeatureVillagePlain.a;
            }, villageSize)));
            biomeGenerationSettingsBuilder.a(customVillage);
        }
        if (worldConfig.getStrongholdsEnabled() && biomeConfig.getStrongholdsEnabled()) {
            biomeGenerationSettingsBuilder.a(StructureFeatures.k);
        }
        if (worldConfig.getOceanMonumentsEnabled() && biomeConfig.getOceanMonumentsEnabled()) {
            biomeGenerationSettingsBuilder.a(StructureFeatures.l);
        }
        if (worldConfig.getRareBuildingsEnabled() && biomeConfig.getRareBuildingType() != SettingsEnums.RareBuildingType.disabled) {
            switch (biomeConfig.getRareBuildingType()) {
                case desertPyramid: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.f);
                    break;
                }
                case igloo: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.g);
                    break;
                }
                case jungleTemple: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.e);
                    break;
                }
                case swampHut: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.j);
                    break;
                }
            }
        }
        if (worldConfig.getWoodlandMansionsEnabled() && biomeConfig.getWoodlandMansionsEnabled()) {
            biomeGenerationSettingsBuilder.a(StructureFeatures.d);
        }
        if (worldConfig.getNetherFortressesEnabled() && biomeConfig.getNetherFortressesEnabled()) {
            biomeGenerationSettingsBuilder.a(StructureFeatures.o);
        }
        if (worldConfig.getMineshaftsEnabled() && biomeConfig.getMineShaftType() != SettingsEnums.MineshaftType.disabled) {
            float mineShaftProbability = biomeConfig.getMineShaftProbability();
            SettingsEnums.MineshaftType mineShaftType = biomeConfig.getMineShaftType();
            StructureFeature customMineShaft = SpigotBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("mineshaft").toResourceLocationString(), StructureGenerator.MINESHAFT.a((WorldGenFeatureConfiguration)new WorldGenMineshaftConfiguration(mineShaftProbability, mineShaftType == SettingsEnums.MineshaftType.mesa ? WorldGenMineshaft.Type.MESA : WorldGenMineshaft.Type.NORMAL)));
            biomeGenerationSettingsBuilder.a(customMineShaft);
        }
        if (worldConfig.getBuriedTreasureEnabled() && biomeConfig.getBuriedTreasureEnabled()) {
            float buriedTreasureProbability = biomeConfig.getBuriedTreasureProbability();
            StructureFeature customBuriedTreasure = SpigotBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("buried_treasure").toResourceLocationString(), StructureGenerator.BURIED_TREASURE.a((WorldGenFeatureConfiguration)new WorldGenFeatureConfigurationChance(buriedTreasureProbability)));
            biomeGenerationSettingsBuilder.a(customBuriedTreasure);
        }
        if (worldConfig.getOceanRuinsEnabled() && biomeConfig.getOceanRuinsType() != SettingsEnums.OceanRuinsType.disabled) {
            float oceanRuinsLargeProbability = biomeConfig.getOceanRuinsLargeProbability();
            float oceanRuinsClusterProbability = biomeConfig.getOceanRuinsClusterProbability();
            SettingsEnums.OceanRuinsType oceanRuinsType = biomeConfig.getOceanRuinsType();
            StructureFeature customOceanRuins = SpigotBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("ocean_ruin").toResourceLocationString(), StructureGenerator.OCEAN_RUIN.a((WorldGenFeatureConfiguration)new WorldGenFeatureOceanRuinConfiguration(oceanRuinsType == SettingsEnums.OceanRuinsType.cold ? WorldGenFeatureOceanRuin.Temperature.COLD : WorldGenFeatureOceanRuin.Temperature.WARM, oceanRuinsLargeProbability, oceanRuinsClusterProbability)));
            biomeGenerationSettingsBuilder.a(customOceanRuins);
        }
        if (worldConfig.getShipWrecksEnabled()) {
            if (biomeConfig.getShipWreckEnabled()) {
                biomeGenerationSettingsBuilder.a(StructureFeatures.h);
            }
            if (biomeConfig.getShipWreckBeachedEnabled()) {
                biomeGenerationSettingsBuilder.a(StructureFeatures.i);
            }
        }
        if (worldConfig.getPillagerOutpostsEnabled() && biomeConfig.getPillagerOutpostEnabled()) {
            int outpostSize = biomeConfig.getPillagerOutPostSize();
            StructureFeature customOutpost = SpigotBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("pillager_outpost").toResourceLocationString(), StructureGenerator.PILLAGER_OUTPOST.a((WorldGenFeatureConfiguration)new WorldGenFeatureVillageConfiguration(() -> WorldGenFeaturePillagerOutpostPieces.a, outpostSize)));
            biomeGenerationSettingsBuilder.a(customOutpost);
        }
        if (worldConfig.getBastionRemnantsEnabled() && biomeConfig.getBastionRemnantEnabled()) {
            int bastionRemnantSize = biomeConfig.getBastionRemnantSize();
            StructureFeature customBastionRemnant = SpigotBiome.register(((OTGBiomeResourceLocation)biomeConfig.getRegistryKey()).withBiomeResource("bastion_remnant").toResourceLocationString(), StructureGenerator.BASTION_REMNANT.a((WorldGenFeatureConfiguration)new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureBastionPieces.a, bastionRemnantSize)));
            biomeGenerationSettingsBuilder.a(customBastionRemnant);
        }
        if (worldConfig.getNetherFossilsEnabled() && biomeConfig.getNetherFossilEnabled()) {
            biomeGenerationSettingsBuilder.a(StructureFeatures.p);
        }
        if (worldConfig.getEndCitiesEnabled() && biomeConfig.getEndCityEnabled()) {
            biomeGenerationSettingsBuilder.a(StructureFeatures.q);
        }
        if (worldConfig.getRuinedPortalsEnabled() && biomeConfig.getRuinedPortalType() != SettingsEnums.RuinedPortalType.disabled) {
            switch (biomeConfig.getRuinedPortalType()) {
                case normal: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.y);
                    break;
                }
                case desert: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.z);
                    break;
                }
                case jungle: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.A);
                    break;
                }
                case swamp: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.B);
                    break;
                }
                case mountain: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.C);
                    break;
                }
                case ocean: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.D);
                    break;
                }
                case nether: {
                    biomeGenerationSettingsBuilder.a(StructureFeatures.E);
                    break;
                }
            }
        }
    }

    private static <FC extends WorldGenFeatureConfiguration, F extends StructureGenerator<FC>> StructureFeature<FC, F> register(String name, StructureFeature<FC, F> structure) {
        return (StructureFeature)RegistryGeneration.a((IRegistry)RegistryGeneration.f, (String)name, structure);
    }

    private static BiomeSettingsMobs.a createMobSpawnInfo(IBiomeConfig biomeConfig) {
        BiomeSettingsMobs.a mobSpawnInfoBuilder = new BiomeSettingsMobs.a();
        SpigotBiome.addMobGroup(EnumCreatureType.MONSTER, mobSpawnInfoBuilder, biomeConfig.getMonsters(), biomeConfig.getName());
        SpigotBiome.addMobGroup(EnumCreatureType.CREATURE, mobSpawnInfoBuilder, biomeConfig.getCreatures(), biomeConfig.getName());
        SpigotBiome.addMobGroup(EnumCreatureType.WATER_CREATURE, mobSpawnInfoBuilder, biomeConfig.getWaterCreatures(), biomeConfig.getName());
        SpigotBiome.addMobGroup(EnumCreatureType.AMBIENT, mobSpawnInfoBuilder, biomeConfig.getAmbientCreatures(), biomeConfig.getName());
        SpigotBiome.addMobGroup(EnumCreatureType.WATER_AMBIENT, mobSpawnInfoBuilder, biomeConfig.getWaterAmbientCreatures(), biomeConfig.getName());
        SpigotBiome.addMobGroup(EnumCreatureType.MISC, mobSpawnInfoBuilder, biomeConfig.getMiscCreatures(), biomeConfig.getName());
        mobSpawnInfoBuilder.a();
        return mobSpawnInfoBuilder;
    }

    private static void addMobGroup(EnumCreatureType creatureType, BiomeSettingsMobs.a mobSpawnInfoBuilder, List<WeightedMobSpawnGroup> mobSpawnGroupList, String biomeName) {
        for (WeightedMobSpawnGroup mobSpawnGroup : mobSpawnGroupList) {
            Optional entityType = EntityTypes.a((String)mobSpawnGroup.getInternalName());
            if (entityType.isPresent()) {
                mobSpawnInfoBuilder.a(creatureType, new BiomeSettingsMobs.c((EntityTypes)entityType.get(), mobSpawnGroup.getWeight(), mobSpawnGroup.getMin(), mobSpawnGroup.getMax()));
                continue;
            }
            if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.MOBS)) continue;
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MOBS, "Could not find entity for mob: " + mobSpawnGroup.getMob() + " in BiomeConfig " + biomeName);
        }
    }

    @Override
    public float getTemperatureAt(int x, int y, int z) {
        return this.biomeBase.getAdjustedTemperature(new BlockPosition(x, y, z));
    }
}

